/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.users;

import com.atlassian.hipchat.api.AbstractMessage;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.MessageFormat;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.glances.RoomAddonUiUpdateData;
import com.atlassian.hipchat.api.users.AllUsersResult;
import com.atlassian.hipchat.api.users.CreateUserResult;
import com.atlassian.hipchat.api.users.InviteUserResult;
import com.atlassian.hipchat.api.users.RecentHistoryResult;
import com.atlassian.hipchat.api.users.User;
import com.atlassian.hipchat.api.users.UserService;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class DefaultUserService<T extends HipChatAPI.TokenType>
implements UserService {
    private final Client client;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultUserService(Client client, HipChatRoutesProvider.Routes<T> routes, ClientResponseMapper mapper) {
        this.client = client;
        this.routes = routes;
        this.mapper = mapper;
    }

    @Override
    public Promise<Result<CreateUserResult>> createUser(String name, String title, String mentionName, boolean isGroupAdmin, String timezone, String password, String email) {
        CreateUserRequest userRequest = new CreateUserRequest(name, title, mentionName, isGroupAdmin, timezone, password, email);
        return this.routes.createUser().flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, userRequest, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.to(CreateUserResult.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<User>> getUser(String idOrEmail) {
        Preconditions.checkNotNull((Object)idOrEmail);
        return this.routes.getUser(idOrEmail).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(User.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> deleteUser(String idOrEmail) {
        Preconditions.checkNotNull((Object)idOrEmail);
        return this.routes.deleteUser(idOrEmail).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> sendPrivateMessage(String username, String message) {
        return this.sendPrivateMessage(username, message, MessageFormat.TEXT);
    }

    @Override
    public Promise<Result<InviteUserResult>> inviteUser(String email, String name, Option<String> title) {
        InviteUserRequest request = new InviteUserRequest(email, name, (String)title.getOrNull());
        return this.routes.inviteUser(email, name, title).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, request, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.to(InviteUserResult.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> sendPrivateMessage(String username, String message, MessageFormat format) {
        PrivateMessage messageObj = new PrivateMessage(message, format, false);
        return this.routes.sendPrivateMessage(username).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, messageObj, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<RecentHistoryResult>> viewRecentHistory(String username, Option<Integer> maxResults, Option<String> timezone, Option<String> notBefore) {
        return this.routes.viewRecentPrivateChatHistory(username, maxResults, timezone, notBefore).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(RecentHistoryResult.class));
    }

    @Override
    public AllUsersRequestBuilder getAllUsers() {
        return new AllUsersRequestBuilder();
    }

    @Override
    public Promise<Result<Void>> updateAddonUiForUser(String userIdOrEmail, RoomAddonUiUpdateData roomAddonUiUpdateData) {
        return this.routes.updateAddonUiForUser(userIdOrEmail).flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, roomAddonUiUpdateData, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    private static class PrivateMessage
    extends AbstractMessage {
        public PrivateMessage(String message, MessageFormat format, boolean notify) {
            super(message, format, notify);
        }

        public PrivateMessage(String message) {
            super(message);
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private static class InviteUserRequest {
        private String name;
        private String email;
        private String title;

        public InviteUserRequest(String email, String name, String title) {
            this.name = name;
            this.email = email;
            this.title = title;
        }

        public InviteUserRequest(String email, String name) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public String getTitle() {
            return this.title;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private static class CreateUserRequest {
        private String name;
        private String title;
        private String mention_name;
        private boolean is_group_admin;
        private String timezone;
        private String password;
        private String email;

        private CreateUserRequest(String name, String title, String mention_name, boolean is_group_admin, String timezone, String password, String email) {
            this.name = name;
            this.title = title;
            this.mention_name = mention_name;
            this.is_group_admin = is_group_admin;
            this.timezone = timezone;
            this.password = password;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMention_name() {
            return this.mention_name;
        }

        public boolean isIs_group_admin() {
            return this.is_group_admin;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public String getPassword() {
            return this.password;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public final class AllUsersRequestBuilder
    implements UserService.AllUsersRequestBuilder {
        Option<Integer> startIndex = Option.none();
        Option<Integer> maxResults = Option.none();
        Option<String> expansions = Option.none();
        Option<Boolean> includeGuests = Option.none();
        Option<Boolean> includeDeleted = Option.none();

        AllUsersRequestBuilder() {
        }

        @Override
        public AllUsersRequestBuilder startIndex(int startIndex) {
            this.startIndex = Option.some((Object)startIndex);
            return this;
        }

        @Override
        public AllUsersRequestBuilder maxResults(int maxResults) {
            this.maxResults = Option.some((Object)maxResults);
            return this;
        }

        @Override
        public AllUsersRequestBuilder includeGuests(boolean includeGuests) {
            this.includeGuests = Option.some((Object)includeGuests);
            return this;
        }

        @Override
        public AllUsersRequestBuilder includeDeleted(boolean includeDeleted) {
            this.includeDeleted = Option.some((Object)includeDeleted);
            return this;
        }

        @Override
        public AllUsersRequestBuilder expand(String expansions) {
            this.expansions = Option.some((Object)expansions);
            return this;
        }

        @Override
        public Promise<Result<AllUsersResult>> build() {
            return DefaultUserService.this.routes.getAllUsers(this.startIndex, this.maxResults, this.includeGuests, this.includeDeleted, this.expansions).flatMap(ResourceMapper.toGetAsyncJsonResource(DefaultUserService.this.client)).map(DefaultUserService.this.mapper.to(AllUsersResult.class)).recover(ResourceMapper.handleError());
        }
    }
}

