/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.connect.descriptor.SynchronisationClassification;
import com.google.common.base.Preconditions;

public enum ConnectDescriptorCompatibility {
    COMPATIBLE(0, SynchronisationClassification.NONE),
    META_DATA_CHANGE(1, SynchronisationClassification.NONE),
    CAPABILITIES_REMOVED(2, SynchronisationClassification.AUTOMATIC),
    CAPABILITIES_ADDED(3, SynchronisationClassification.AUTOMATIC),
    IDENTITY_CHANGE(4, SynchronisationClassification.USER_APPROVED),
    SCOPE_INCREASE(5, SynchronisationClassification.USER_APPROVED);

    private final int incompatibilitySeverity;
    private final SynchronisationClassification synchronisationClassification;

    private ConnectDescriptorCompatibility(int incompatibilitySeverity, SynchronisationClassification synchronisationClassification) {
        this.incompatibilitySeverity = incompatibilitySeverity;
        this.synchronisationClassification = synchronisationClassification;
    }

    public static ConnectDescriptorCompatibility mostIncompatible(ConnectDescriptorCompatibility compatibilityA, ConnectDescriptorCompatibility compatibilityB) {
        Preconditions.checkNotNull((Object)((Object)compatibilityA));
        Preconditions.checkNotNull((Object)((Object)compatibilityB));
        if (compatibilityA.incompatibilitySeverity > compatibilityB.incompatibilitySeverity) {
            return compatibilityA;
        }
        return compatibilityB;
    }

    public SynchronisationClassification getSynchronisationClassification() {
        return this.synchronisationClassification;
    }
}

