/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava11.memory;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheException;
import com.atlassian.cache.compat.CacheSettings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import java.util.Collection;
import javax.annotation.Nullable;

class MemoryCache<K, V>
implements Cache<K, V> {
    private final String name;
    private final com.google.common.cache.Cache<K, V> internalCache;

    private MemoryCache(com.google.common.cache.Cache<K, V> internalCache, String name) {
        this.internalCache = internalCache;
        this.name = name;
    }

    static <K, V> MemoryCache<K, V> create(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings) {
        return new MemoryCache<K, V>(internalCache, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<K> getKeys() {
        try {
            return this.internalCache.asMap().keySet();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            this.internalCache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public V get(K key) {
        try {
            if (this.internalCache instanceof LoadingCache) {
                return (V)((LoadingCache)this.internalCache).get(key);
            }
            return this.internalCache.asMap().get(key);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.internalCache.invalidate(key);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void removeAll() {
        try {
            this.internalCache.invalidateAll();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof MemoryCache) {
            MemoryCache otherMemoryCache = (MemoryCache)other;
            if (this.internalCache.equals(otherMemoryCache.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

