/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava10.memory;

import com.atlassian.cache.compat.CacheException;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.impl.ReferenceKey;
import com.google.common.collect.ComputationException;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

class MemoryCachedReference<V>
implements CachedReference<V> {
    private final ConcurrentMap<ReferenceKey, V> internalCache;

    private MemoryCachedReference(ConcurrentMap<ReferenceKey, V> internalCache) {
        this.internalCache = internalCache;
    }

    static <V> MemoryCachedReference<V> create(ConcurrentMap<ReferenceKey, V> internalCache) {
        return new MemoryCachedReference<V>(internalCache);
    }

    @Override
    public V get() {
        try {
            return this.internalCache.get(ReferenceKey.KEY);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void reset() {
        try {
            this.internalCache.remove(ReferenceKey.KEY);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof MemoryCachedReference) {
            MemoryCachedReference otherDelegatingReference = (MemoryCachedReference)other;
            if (this.internalCache.equals(otherDelegatingReference.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

