/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.link;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.groups.ExpandedGroup;
import com.atlassian.hipchat.api.groups.GroupService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.link.HipChatDomainManager;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultHipChatDomainManager
implements HipChatDomainManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatDomainManager.class);
    private static final String HIPCHAT_COM = ".hipchat.com";
    private static final String DEFAULT_SUBDOMAIN = "api";
    private static final int TIMEOUT = 30;
    private final HipChatLinkProvider provider;

    @Autowired
    public DefaultHipChatDomainManager(HipChatLinkProvider provider) {
        this.provider = provider;
    }

    @Override
    @Nonnull
    public String getDefaultDomain() {
        Option<HipChatLink> defaultLink = this.provider.getDefaultLink();
        String subDomain = DEFAULT_SUBDOMAIN;
        if (defaultLink.isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)defaultLink.get();
            if (hipChatLink.getAddonApi().features().isBtf()) {
                return hipChatLink.getApiUrl();
            }
            subDomain = this.getSubDomain(hipChatLink);
        }
        return "https://" + subDomain + HIPCHAT_COM;
    }

    private String getSubDomain(HipChatLink hipChatLink) {
        String subDomain = DEFAULT_SUBDOMAIN;
        try {
            String groupId = String.valueOf(hipChatLink.getGroupId());
            GroupService groups = hipChatLink.getAddonApi().groups();
            Promise<Result<ExpandedGroup>> groupResult = groups.getGroup(groupId, (Option<String>)Option.none());
            Result result = (Result)groupResult.get(30L, TimeUnit.SECONDS);
            if (result.isSuccess()) {
                subDomain = ((ExpandedGroup)result.success()).getSubDomain();
            } else {
                logger.error(" Failing to generate the url of HipChat : ", result.error().toThrowable());
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the domain from HipChat. Default subdomain 'api' will be used. Error : ", (Throwable)e);
        }
        return subDomain;
    }
}

