/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.CollapsedEntity;
import com.atlassian.hipchat.api.Result;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.util.concurrent.SettableFuture;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.async.TypeListener;
import com.sun.jersey.api.representation.Form;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceMapper.class);

    public static Function<URI, Promise<ClientResponse>> toGetAsyncJsonResource(final Client client) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture result = SettableFuture.create();
                client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ResourceMapper.async((SettableFuture<ClientResponse>)result));
                return ResourceMapper.forFuture(result);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toGetAsync(final Client client) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture result = SettableFuture.create();
                client.asyncResource(input).get(ResourceMapper.async((SettableFuture<ClientResponse>)result));
                return ResourceMapper.forFuture(result);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toConditionalGetAsyncJsonResource(final Client client, final Option<String> etag) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nullable URI input) {
                AsyncWebResource.Builder responseBuilder = client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
                if (etag.isDefined()) {
                    responseBuilder = (AsyncWebResource.Builder)responseBuilder.header("If-None-Match", etag.get());
                }
                SettableFuture future = SettableFuture.create();
                responseBuilder.get(ResourceMapper.async((SettableFuture<ClientResponse>)future));
                return ResourceMapper.forFuture(future);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toDeleteAsyncJsonResource(final Client client) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture future = SettableFuture.create();
                client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(ResourceMapper.async((SettableFuture<ClientResponse>)future));
                return ResourceMapper.forFuture(future);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPostAsyncJsonResource(final Client client, final Object data, final MediaType sendType) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture future = SettableFuture.create();
                ((AsyncWebResource.Builder)client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(sendType)).post(ResourceMapper.async((SettableFuture<ClientResponse>)future), data);
                return ResourceMapper.forFuture(future);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPutAsyncJsonResource(final Client client, final Object data, final MediaType sendType) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture future = SettableFuture.create();
                ((AsyncWebResource.Builder)client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(sendType)).put(ResourceMapper.async((SettableFuture<ClientResponse>)future), data);
                return ResourceMapper.forFuture(future);
            }
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPostAsyncFormResource(final Client client, final Form data) {
        return new Function<URI, Promise<ClientResponse>>(){

            public Promise<ClientResponse> apply(@Nonnull URI input) {
                SettableFuture future = SettableFuture.create();
                client.asyncResource(input).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(ResourceMapper.async((SettableFuture<ClientResponse>)future), (Object)data);
                return ResourceMapper.forFuture(future);
            }
        };
    }

    public static <T> Function<Throwable, Result<T>> handleError() {
        return new Function<Throwable, Result<T>>(){

            public Result<T> apply(Throwable input) {
                LOGGER.debug("Unexpected error encountered communicating with HipChat.", input);
                return Result.error(input);
            }
        };
    }

    public static <T> Function<CollapsedEntity<T>, T> expandAll() {
        return new Function<CollapsedEntity<T>, T>(){

            public T apply(CollapsedEntity<T> input) {
                return input.expanded();
            }
        };
    }

    public static ITypeListener<ClientResponse> async(final SettableFuture<ClientResponse> future) {
        return new TypeListener<ClientResponse>(ClientResponse.class){

            public void onComplete(Future<ClientResponse> f) throws InterruptedException {
                try {
                    ClientResponse t = f.get();
                    future.set((Object)t);
                }
                catch (ExecutionException e) {
                    future.setException((Throwable)e);
                }
            }
        };
    }

    public static <T> Promise<T> forFuture(SettableFuture<T> future) {
        return Promises.forListenableFuture(future);
    }
}

