/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.link;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.plugins.hipchat.ao.InternalHipChatLink;
import com.atlassian.plugins.hipchat.api.DefaultHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.routes.HipChatAPIFactory;
import com.atlassian.plugins.hipchat.link.HipChatLinkConverter;
import com.atlassian.plugins.hipchat.token.HipChatTokenRefreshService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.base.Function;

@Internal
public class DefaultHipChatLinkConverter
implements HipChatLinkConverter {
    private final HipChatRoutesProvider routesProvider;
    private final HipChatTokenRefreshService hipChatTokenRefreshService;
    private final HipChatAPIFactory hipChatAPIFactory;
    private final UserManager userManager;

    public DefaultHipChatLinkConverter(HipChatRoutesProvider routesProvider, HipChatTokenRefreshService hipChatTokenRefreshService, HipChatAPIFactory hipChatAPIFactory, UserManager userManager) {
        this.routesProvider = routesProvider;
        this.hipChatTokenRefreshService = hipChatTokenRefreshService;
        this.hipChatAPIFactory = hipChatAPIFactory;
        this.userManager = userManager;
    }

    @Override
    public Function<InternalHipChatLink, HipChatLink> toHipChatLink() {
        return new Function<InternalHipChatLink, HipChatLink>(){

            public HipChatLink apply(InternalHipChatLink link) {
                Option personalApiOption;
                Option<HipChatTokenReference> personalTokenOption;
                HipChatTokenReference addonToken = DefaultHipChatLinkConverter.this.hipChatTokenRefreshService.refreshableAddonToken(link);
                HipChatRoutesProvider.Routes addonRoutes = DefaultHipChatLinkConverter.this.routesProvider.routes(link.getApiUrl(), addonToken);
                HipChatTokenReference systemUserToken = DefaultHipChatLinkConverter.this.hipChatTokenRefreshService.refreshableSystemUserToken(link);
                HipChatRoutesProvider.Routes systemUserRoutes = DefaultHipChatLinkConverter.this.routesProvider.routes(link.getApiUrl(), systemUserToken);
                HipChatAPI<HipChatAPI.TokenType.AddonToken> addonAPI = DefaultHipChatLinkConverter.this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.AddonToken.AddonToken, addonRoutes, link, null);
                HipChatAPI<HipChatAPI.TokenType.SystemUserToken> systemUserAPI = DefaultHipChatLinkConverter.this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.SystemUserToken.SystemUserToken, systemUserRoutes, link, null);
                UserProfile remoteUser = DefaultHipChatLinkConverter.this.userManager.getRemoteUser();
                Option<HipChatTokenReference> option = personalTokenOption = remoteUser != null ? DefaultHipChatLinkConverter.this.hipChatTokenRefreshService.refreshablePersonalToken(remoteUser.getUserKey()) : Option.none();
                if (personalTokenOption.isDefined()) {
                    HipChatRoutesProvider.Routes personalRoutes = DefaultHipChatLinkConverter.this.routesProvider.routes(link.getApiUrl(), (HipChatTokenReference)personalTokenOption.get());
                    personalApiOption = Option.some(DefaultHipChatLinkConverter.this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.PersonalToken.PersonalToken, personalRoutes, link, remoteUser.getUserKey()));
                } else {
                    personalApiOption = Option.none();
                }
                return new DefaultHipChatLink(new HipChatLinkId(link.getID()), link, systemUserAPI, addonAPI, (Option<HipChatAPI<HipChatAPI.TokenType.PersonalToken>>)personalApiOption);
            }
        };
    }
}

