/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.cards;

import com.atlassian.fugue.Option;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Card {
    private final Style style;
    private final Format format;
    private final URL url;
    private final String id;
    private final Icon icon;
    private final String title;
    private final Description description;
    private final Map<ImageSize, URL> images;
    private final String date;
    private final Collection<Attribute> attributes;
    private final Activity activity;
    private final Map<String, Object> metadata;

    private Card(Style style, Format format, URL url, String id, Icon icon, String title, Description description, Map<ImageSize, URL> images, String date, Collection<Attribute> attributes, Activity activity, Map<String, Object> metadata) {
        this.style = style;
        this.format = format;
        this.url = url;
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.images = images;
        this.date = date;
        this.attributes = attributes;
        this.activity = activity;
        this.metadata = metadata;
    }

    @JsonCreator
    public Card(@JsonProperty(value="style") String style, @JsonProperty(value="format") String format, @JsonProperty(value="url") String url, @JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonDeserialize(as=Icon.class) @JsonProperty(value="icon") Icon icon, @JsonDeserialize(as=Description.class) @JsonProperty(value="description") Description description, @JsonDeserialize(contentAs=Attribute.class) @JsonProperty(value="attributes") Collection<Attribute> attributes, @JsonDeserialize(as=HtmlActivity.class) @JsonProperty(value="activity") HtmlActivity activity, @JsonDeserialize(as=Map.class) @JsonProperty(value="metadata") Map<String, Object> metadata) throws MalformedURLException {
        this.style = Style.valueOf(style);
        this.format = format != null ? Format.valueOf(format) : null;
        this.url = new URL(url);
        this.title = title;
        this.id = id;
        this.icon = icon;
        this.description = description;
        this.metadata = metadata;
        this.images = null;
        this.date = null;
        this.attributes = attributes;
        this.activity = activity;
    }

    public Style getStyle() {
        return this.style;
    }

    public Format getFormat() {
        return this.format;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public Description getDescription() {
        return this.description;
    }

    public Map<ImageSize, URL> getImages() {
        return this.images;
    }

    public String getDate() {
        return this.date;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        if (this.style != card.style) {
            return false;
        }
        if (this.url != null ? !this.url.equals(card.url) : card.url != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(card.id) : card.id != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(card.icon) : card.icon != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals((Object)card.format) : card.format != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(card.title) : card.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(card.description) : card.description != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(card.images) : card.images != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(card.getDate()) : card.date != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(card.attributes) : card.attributes != null) {
            return false;
        }
        return !(this.activity == null ? card.activity != null : !this.activity.equals(card.activity));
    }

    public int hashCode() {
        int result = this.style != null ? this.style.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.images != null ? this.images.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.activity != null ? this.activity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Card{style=" + (Object)((Object)this.style) + ", format=" + (Object)((Object)this.format) + ", url=" + this.url + ", id='" + this.id + '\'' + ", icon=" + this.icon + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", images=" + this.images + ", date='" + this.date + '\'' + ", attributes=" + this.attributes + ", activity=" + this.activity + '}';
    }

    public static Builder builder(Style style, URL url, String id) {
        return new Builder(style, url, id);
    }

    public static Builder builder(Style style, String id) {
        return new Builder(style, id);
    }

    public static class TextActivity
    extends Activity {
        public TextActivity(String contents, Option<URL> icon) {
            super(contents, icon);
        }

        public String getText() {
            return this.getContents();
        }
    }

    public static class HtmlActivity
    extends Activity {
        @JsonCreator
        public HtmlActivity(@JsonProperty(value="html") String contents, @JsonProperty(value="icon") String icon) throws MalformedURLException {
            super(contents, (Option<URL>)(StringUtils.isNotBlank((CharSequence)icon) ? Option.some((Object)new URL(icon)) : Option.none()));
        }

        public HtmlActivity(String contents, Option<URL> icon) {
            super(contents, icon);
        }

        public String getHtml() {
            return this.getContents();
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Description {
        private final String value;
        private final DescriptionFormat format;

        public Description(DescriptionFormat format, String value) {
            this.format = format;
            this.value = value;
        }

        @JsonCreator
        public Description(@JsonProperty(value="format") String format, @JsonProperty(value="value") String value) {
            this.format = DescriptionFormat.valueOf(format);
            this.value = value;
        }

        public DescriptionFormat getFormat() {
            return this.format;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Description that = (Description)o;
            if (this.format != null ? !this.format.equals((Object)that.format) : that.format != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            return result;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static abstract class Activity {
        private final String contents;
        private final Option<URL> icon;

        protected Activity(String contents, Option<URL> icon) {
            this.contents = contents;
            this.icon = icon;
        }

        public URL getIcon() {
            return (URL)this.icon.getOrNull();
        }

        protected String getContents() {
            return this.contents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Activity activity = (Activity)o;
            if (this.contents != null ? !this.contents.equals(activity.contents) : activity.contents != null) {
                return false;
            }
            return !(this.icon == null ? activity.icon != null : !this.icon.equals(activity.icon));
        }

        public int hashCode() {
            int result = this.contents != null ? this.contents.hashCode() : 0;
            result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Activity{contents='" + this.contents + '\'' + ", icon=" + this.icon + '}';
        }
    }

    public static class Icon {
        private final URL url;

        @JsonCreator
        public Icon(@JsonProperty(value="url") URL url) {
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Icon icon = (Icon)o;
            return !(this.url == null ? icon.url != null : !this.url.equals(icon.url));
        }

        public int hashCode() {
            return this.url != null ? this.url.hashCode() : 0;
        }

        public String toString() {
            return "Icon{url=" + this.url + '}';
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Attribute {
        private final String label;
        private final Value value;

        @JsonCreator
        public Attribute(@JsonProperty(value="label") String label, @JsonDeserialize(as=Value.class) @JsonProperty(value="value") Value value) {
            this.label = label;
            this.value = value;
        }

        public Attribute(String label, String value) {
            this(label, Value.builder().setLabel(value).build());
        }

        public String getLabel() {
            return this.label;
        }

        public Value getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            if (this.label != null ? !this.label.equals(attribute.label) : attribute.label != null) {
                return false;
            }
            return !(this.value == null ? attribute.value != null : !this.value.equals(attribute.value));
        }

        public int hashCode() {
            int result = this.label != null ? this.label.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Attribute{label='" + this.label + '\'' + ", value=" + this.value + '}';
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Value {
        private final URL icon;
        private final String label;
        private final String style;
        private final URL url;

        public Value(URL icon, String label, String style, URL url) {
            this.icon = icon;
            this.label = label;
            this.style = style;
            this.url = url;
        }

        @JsonCreator
        public Value(@JsonProperty(value="icon") String icon, @JsonProperty(value="label") String label, @JsonProperty(value="style") String style, @JsonProperty(value="url") String url) throws MalformedURLException {
            this.icon = icon != null ? new URL(icon) : null;
            this.label = label;
            this.style = style;
            this.url = url != null ? new URL(url) : null;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String getLabel() {
            return this.label;
        }

        public String getStyle() {
            return this.style;
        }

        public URL getUrl() {
            return this.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            if (this.icon != null ? !this.icon.equals(value.icon) : value.icon != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(value.label) : value.label != null) {
                return false;
            }
            if (this.style != null ? !this.style.equals(value.style) : value.style != null) {
                return false;
            }
            return !(this.url == null ? value.url != null : !this.url.equals(value.url));
        }

        public int hashCode() {
            int result = this.icon != null ? this.icon.hashCode() : 0;
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Value{icon=" + this.icon + ", label='" + this.label + '\'' + ", style='" + this.style + '\'' + ", url=" + this.url + '}';
        }

        public static class Builder {
            private URL icon;
            private String label;
            private String style;
            private URL url;

            private Builder() {
            }

            public Builder setStyle(String style) {
                this.style = style;
                return this;
            }

            public Builder setIcon(URL icon) {
                this.icon = icon;
                return this;
            }

            public Builder setLabel(String label) {
                this.label = label;
                return this;
            }

            public Builder setUrl(URL url) {
                this.url = url;
                return this;
            }

            public Value build() {
                return new Value(this.icon, this.label, this.style, this.url);
            }
        }
    }

    public static class Builder {
        private Style style;
        private Format format;
        private URL url;
        private String id;
        private Icon icon;
        private String title;
        private Description description;
        private Map<ImageSize, URL> images = Maps.newHashMap();
        private String date;
        private Collection<Attribute> attributes = Lists.newArrayList();
        private Activity activity;
        private Map<String, Object> metadata = null;

        private Builder(Style style, URL url, String id) {
            this.style = style;
            this.url = url;
            this.id = id;
        }

        private Builder(Style style, String id) {
            this.style = style;
            this.id = id;
        }

        public Card build() {
            if (this.id == null) {
                throw new RuntimeException("a Card must have an id");
            }
            if (this.title == null) {
                throw new RuntimeException("a Card must have a title");
            }
            return new Card(this.style, this.format, this.url, this.id, this.icon, this.title, this.description, this.images, this.date, this.attributes, this.activity, this.metadata);
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setDescription(String description) {
            if (description.length() > 0) {
                this.description = new Description(DescriptionFormat.text, description);
            }
            return this;
        }

        public Builder setHtmlDescription(String description) {
            if (description.length() > 0) {
                this.description = new Description(DescriptionFormat.html, description);
            }
            return this;
        }

        public Builder setDate(Date date) {
            this.date = Long.toString(date.getTime() / 1000L);
            return this;
        }

        public Builder setIcon(URL iconUrl) {
            this.icon = new Icon(iconUrl);
            return this;
        }

        public Builder addAttribute(Attribute a) {
            this.attributes.add(a);
            return this;
        }

        public Builder setActivity(Activity activity) {
            this.activity = activity;
            this.setFormat(Format.medium);
            return this;
        }

        public Builder setTextActivity(String text, Option<URL> icon) {
            return this.setActivity(new TextActivity(text, icon));
        }

        public Builder setHtmlActivity(String html, Option<URL> icon) {
            return this.setActivity(new HtmlActivity(html, icon));
        }

        public Builder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder addAttribute(String label, Value value) {
            return this.addAttribute(new Attribute(label, value));
        }

        public Builder addAttribute(String label, String value) {
            return this.addAttribute(new Attribute(label, value));
        }

        public Builder addMetadata(String key, Object value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Object>();
            }
            this.metadata.put(key, value);
            return this;
        }
    }

    public static enum ImageSize {
        image("image"),
        small("image-small"),
        big("image-big");

        private final String value;

        private ImageSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DescriptionFormat {
        html,
        text;

    }

    public static enum Format {
        compact,
        medium;

    }

    public static enum Style {
        file,
        image,
        application;

    }
}

