/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.projectcreate;

import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.projectcreate.spi.AggregateRoot;
import com.atlassian.plugins.projectcreate.spi.AggregateRootSubType;
import com.atlassian.plugins.projectcreate.spi.AggregateRootTypeCapability;
import com.atlassian.plugins.projectcreate.spi.ResponseStatusWithMessage;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang.StringUtils;

public class BambooProjectAggregateRootTypeCapability
implements AggregateRootTypeCapability {
    private final ProjectManager projectManager;
    private final BambooUserManager bambooUserManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final DeletionService deletionService;
    private final Function<Project, AggregateRoot> PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION;

    public BambooProjectAggregateRootTypeCapability(ProjectManager projectManager, BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager, DeletionService deletionService, final ApplicationProperties applicationProperties) {
        this.projectManager = projectManager;
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.deletionService = deletionService;
        this.PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION = new Function<Project, AggregateRoot>(){

            public AggregateRoot apply(Project project) {
                return AggregateRoot.makeAggregateRoot((String)project.getKey(), (String)StringUtils.defaultString((String)project.getName()), (String)(applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/browse/"));
            }
        };
    }

    public String getType() {
        return "bamboo.project";
    }

    public String getLabelI18nKey() {
        return "bamboo.projectcreate.project.label";
    }

    public String getDescriptionI18nKey() {
        return "bamboo.projectcreate.project.description";
    }

    public boolean isAvailable() {
        return true;
    }

    public Iterable<AggregateRootSubType> getSubTypes() {
        return ImmutableList.of();
    }

    public Iterable<AggregateRoot> getExistingRoots() {
        Set bambooProjects = this.projectManager.getAllProjects();
        return Iterables.transform((Iterable)bambooProjects, this.PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION);
    }

    public boolean canUserCreateRoot(String username) {
        BambooUser user = this.bambooUserManager.getBambooUser(username);
        if (user != null) {
            return this.bambooPermissionManager.isSystemAdmin(username) || this.bambooPermissionManager.isAdmin(username);
        }
        return false;
    }

    public Option<AggregateRoot> getRootByKey(Option<String> maybeUsername, final String entityKey) {
        return maybeUsername.filter((Predicate)new Predicate<String>(){

            public boolean apply(String username) {
                return BambooProjectAggregateRootTypeCapability.this.bambooPermissionManager.hasPermission(username, (Permission)BambooPermission.READ, (Object)GlobalApplicationSecureObject.INSTANCE);
            }
        }).flatMap((Function)new Function<String, Option<Project>>(){

            public Option<Project> apply(String username) {
                return Option.option((Object)BambooProjectAggregateRootTypeCapability.this.projectManager.getProjectByKey(entityKey));
            }
        }).map(this.PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION);
    }

    public Either<ResponseStatusWithMessage, AggregateRoot> createRoot(final String username, final String key, final String name, Option<String> subtypeKey, Map<String, String> context) {
        return (Either)subtypeKey.fold((Supplier)new Supplier<Either<ResponseStatusWithMessage, AggregateRoot>>(){

            public Either<ResponseStatusWithMessage, AggregateRoot> get() {
                if (BambooProjectAggregateRootTypeCapability.this.canUserCreateRoot(username)) {
                    if (BambooProjectAggregateRootTypeCapability.this.projectManager.getProjectByKey(key) == null) {
                        Project project = BambooProjectAggregateRootTypeCapability.this.projectManager.createProject(key, name);
                        BambooProjectAggregateRootTypeCapability.this.projectManager.saveProject(project);
                        return Either.right((Object)BambooProjectAggregateRootTypeCapability.this.PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION.apply((Object)project));
                    }
                    return Either.left((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, "bamboo.projectcreate.project.duplicate.key", new String[0]));
                }
                return Either.left((Object)new ResponseStatusWithMessage(Response.Status.UNAUTHORIZED, "bamboo.projectcreate.project.no.admin.permissions", new String[0]));
            }
        }, (Function)new Function<String, Either<ResponseStatusWithMessage, AggregateRoot>>(){

            public Either<ResponseStatusWithMessage, AggregateRoot> apply(@Nullable String input) {
                return Either.left((Object)new ResponseStatusWithMessage(Response.Status.NOT_FOUND, "atlassian.project.create.unknown.subtype", new String[]{input}));
            }
        });
    }

    public Either<ResponseStatusWithMessage, ResponseStatusWithMessage> deleteRoot(String username, String entityKey) {
        if (this.canUserCreateRoot(username)) {
            Project project = this.projectManager.getProjectByKey(entityKey);
            if (project != null) {
                if (!project.isMarkedForDeletion()) {
                    this.deletionService.deleteProject(project);
                    return Either.right((Object)new ResponseStatusWithMessage(Response.Status.ACCEPTED, "bamboo.projectcreate.project.delete.accepted", new String[0]));
                }
                return Either.right((Object)new ResponseStatusWithMessage(Response.Status.GONE, "bamboo.projectcreate.project.delete.marked.for.deletion", new String[0]));
            }
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.NOT_FOUND, "bamboo.projectcreate.project.not.found", new String[0]));
        }
        return Either.left((Object)new ResponseStatusWithMessage(Response.Status.UNAUTHORIZED, "bamboo.projectcreate.project.no.admin.permissions", new String[0]));
    }

    public void flushPluginSettings() {
    }
}

