package com.atlassian.plugins.avatar;

/**
 * Convenience base class implements some methods.
 */
@SuppressWarnings({ "UnusedDeclaration", "FieldMayBeFinal" })
abstract public class AbstractAvatar implements Avatar {
    private final String ownerId;
    private final String contentType;
    private final int size;

    public AbstractAvatar(String ownerId, String contentType, int size) {
        this.ownerId = ownerId;
        this.contentType = contentType;
        this.size = size;
    }

    @Override
    public String getOwnerId() {
        return ownerId;
    }

    @Override
    public int getSize() {
        return size;
    }

    @Override
    public String getContentType() {
        return contentType;
    }
}
