/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.upgrade;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.MappingExpression;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class UpgradeTask05SupportMappingExpressionsForUsernameField
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask05SupportMappingExpressionsForUsernameField.class);
    private static final String DEFAULT_SAML_USERNAME_ATTRIBUTE_EXPRESSION = "${NameID}";
    private static final String DEFAULT_OIDC_USERNAME_CLAIM_EXPRESSION = "${sub}";
    private final SsoConfigService ssoConfigService;

    @Inject
    public UpgradeTask05SupportMappingExpressionsForUsernameField(SsoConfigService ssoConfigService) {
        this.ssoConfigService = ssoConfigService;
    }

    public int getBuildNumber() {
        return 5;
    }

    public String getShortDescription() {
        return "Migrate values of Username attribute/claim (SAML/OIDC) field to meet new non-empty requirement and mapping expression compatibility.";
    }

    public Collection<Message> doUpgrade() {
        SsoType ssoType = this.ssoConfigService.getSsoType();
        if (ssoType == SsoType.SAML) {
            SamlConfig updatedSamlConfig = this.ssoConfigService.getSamlConfigOrFail().toBuilder().setUsernameAttribute(DEFAULT_SAML_USERNAME_ATTRIBUTE_EXPRESSION).build();
            this.ssoConfigService.updateSsoConfig(updatedSamlConfig);
            log.info("Upgraded SSO SAML configuraton with new username attribute field [{}]", (Object)updatedSamlConfig.getUsernameAttribute());
        } else if (ssoType == SsoType.OIDC) {
            OidcConfig oidcConfig = this.ssoConfigService.getOidcConfigOrFail();
            String updatedUsernameClaim = this.evaluateNewOidcUsernameClaimValue(oidcConfig.getUsernameClaim());
            OidcConfig updatedOidcConfig = oidcConfig.toBuilder().setUsernameClaim(updatedUsernameClaim).build();
            this.ssoConfigService.updateSsoConfig(updatedOidcConfig);
            log.info("Upgraded SSO OIDC username claim from [{}] to [{}}]", (Object)oidcConfig.getUsernameClaim(), (Object)updatedUsernameClaim);
        }
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.atlassian.plugins.authentication.atlassian-authentication-plugin";
    }

    private String evaluateNewOidcUsernameClaimValue(String usernameClaim) {
        if (Strings.isNullOrEmpty((String)usernameClaim)) {
            return DEFAULT_OIDC_USERNAME_CLAIM_EXPRESSION;
        }
        return MappingExpression.toMappingExpressionVariable(usernameClaim);
    }
}

