/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.JitCrowdUser;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.JitException;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.JitUserData;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ProvisioningService {
    private static final Logger log = LoggerFactory.getLogger(ProvisioningService.class);
    private final CrowdService crowdService;
    private final ProductLicenseChecker productLicenseChecker;
    private final DirectoryManager directoryManager;
    private final DarkFeatureManager darkFeatureManager;

    public ProvisioningService(@ComponentImport CrowdService crowdService, @ComponentImport DirectoryManager directoryManager, @ComponentImport DarkFeatureManager darkFeatureManager, ProductLicenseChecker productLicenseChecker) {
        this.crowdService = crowdService;
        this.productLicenseChecker = productLicenseChecker;
        this.directoryManager = directoryManager;
        this.darkFeatureManager = darkFeatureManager;
    }

    public Optional<JitCrowdUser> findUserInternally(JitUserData jitUserData) {
        Optional<JitCrowdUser> userByIdpId = this.getUserByIdentityProviderId(jitUserData.getIdentityProviderId());
        if (userByIdpId.isPresent()) {
            return userByIdpId;
        }
        return this.findUserInInternalDirectoryByName(jitUserData);
    }

    public JitCrowdUser provisionUser(JitUserData userData) {
        log.debug("Attempting to JIT provision unrecognized user [{}]", (Object)userData.getUsername());
        JitCrowdUser newUser = new JitCrowdUser(userData);
        try {
            if (!this.darkFeatureManager.isEnabledForAllUsers("atlassian.authentication.sso.jit.disable.license.check").orElse(false).booleanValue() && !this.productLicenseChecker.areSlotsAvailable(userData.getGroups())) {
                log.error("Did not provision user [{}] as license limit would have been exceeded", (Object)userData.getUsername());
                throw new JitException("User could not be created due to the license\u2019s limit.");
            }
            this.crowdService.addUser((UserWithAttributes)newUser, this.generatePassword());
            return newUser;
        }
        catch (InvalidUserException e) {
            log.error("User [{}] was invalid when being provisioned JIT: {}", (Object)userData.getUsername(), (Object)e.getMessage());
            throw new JitException(e);
        }
        catch (InvalidCredentialException e) {
            log.error("Generated password for user [{}] was invalid when being provisioned JIT: {}", (Object)userData.getUsername(), (Object)e.getViolatedConstraints());
            throw new JitException(e);
        }
        catch (OperationNotPermittedException e) {
            log.error("JIT provisioning of user [{}] was not permitted: {}", (Object)userData.getUsername(), (Object)e.getMessage());
            throw new JitException(e);
        }
    }

    public JitCrowdUser updateUser(JitUserData userData, JitCrowdUser existingUser) {
        log.debug("Attempting to update JIT user [{}]", (Object)userData.getUsername());
        try {
            JitCrowdUser user = existingUser;
            if (!userData.getIdentityProviderId().equals(existingUser.getValue("jit_idp_id"))) {
                this.crowdService.setUserAttribute((User)user, "jit_idp_id", userData.getIdentityProviderId());
            }
            if (!userData.getUsername().equals(user.getName())) {
                user = this.crowdService.renameUser((User)user, userData.getUsername());
            }
            if (!userData.getDisplayName().equals(user.getDisplayName()) || !userData.getEmail().equals(user.getEmailAddress())) {
                UserTemplate updatedUserTemplate = new UserTemplate((User)user);
                updatedUserTemplate.setDisplayName(userData.getDisplayName());
                updatedUserTemplate.setEmailAddress(userData.getEmail());
                user = this.crowdService.updateUser((User)updatedUserTemplate);
            }
            return new JitCrowdUser(userData.getIdentityProviderId(), (User)user);
        }
        catch (InvalidUserException e) {
            log.error("User [{}] was invalid when being updated JIT: {}", (Object)userData.getUsername(), (Object)e.getMessage());
            throw new JitException(e);
        }
        catch (OperationNotPermittedException e) {
            log.error("Updating JIT user [{}] was not permitted: {}", (Object)userData.getUsername(), (Object)e.getMessage());
            throw new JitException(e);
        }
    }

    public void updateUserGroups(JitCrowdUser user, Set<String> newGroupNames) {
        Set<Group> currentUserGroups = this.getUserGroups(user.getName());
        Set<Group> groupsToRemoveFrom = currentUserGroups.stream().filter(group -> !newGroupNames.contains(group.getName())).collect(Collectors.toSet());
        Set<String> groupsToAddTo = newGroupNames.stream().filter(group -> !currentUserGroups.stream().map(Group::getName).collect(Collectors.toSet()).contains(group)).collect(Collectors.toSet());
        log.debug("Updating groups for JIT user [{}]: removing from [{}], adding to [{}]", new Object[]{user.getName(), groupsToRemoveFrom.stream().map(Group::getName).collect(Collectors.toSet()), groupsToAddTo});
        this.removeUserFromGroups((User)user, groupsToRemoveFrom);
        this.addUserToGroups((User)user, groupsToAddTo);
    }

    private Set<Group> getUserGroups(String username) {
        Iterable result = this.crowdService.search((Query)QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(Integer.MAX_VALUE));
        return StreamSupport.stream(result.spliterator(), false).collect(Collectors.toSet());
    }

    private void removeUserFromGroups(User user, Set<Group> groups) {
        groups.forEach(group -> {
            try {
                log.debug("Removing user [{}] from group [{}]", (Object)user.getName(), (Object)group.getName());
                this.crowdService.removeUserFromGroup(user, group);
            }
            catch (OperationNotPermittedException e) {
                log.error("Removing user [{}] from group [{}] was not permitted: {}", new Object[]{user.getName(), group.getName(), e.getMessage()});
                throw new JitException(e);
            }
        });
    }

    private void addUserToGroups(User user, Set<String> groupNames) {
        groupNames.forEach(groupName -> {
            Group group = this.crowdService.getGroup(groupName);
            if (group == null) {
                group = this.provisionGroup((String)groupName);
            }
            try {
                log.debug("Adding user [{}] to group [{}]", (Object)user.getName(), (Object)group.getName());
                this.crowdService.addUserToGroup(user, group);
            }
            catch (OperationNotPermittedException e) {
                log.error("Adding user [{}] to group [{}] was not permitted: {}", new Object[]{user, groupName, e.getMessage()});
                throw new JitException(e);
            }
        });
    }

    private Group provisionGroup(String name) {
        try {
            log.debug("JIT provisioning group [{}]", (Object)name);
            return this.crowdService.addGroup((Group)new ImmutableGroup(name));
        }
        catch (InvalidGroupException e) {
            log.error("Group [{}] was invalid when being provisioned JIT: {}", (Object)name, (Object)e.getMessage());
            throw new JitException(e);
        }
        catch (OperationNotPermittedException e) {
            log.error("Adding group [{}] was not permitted: {}", (Object)name, (Object)e.getMessage());
            throw new JitException(e);
        }
    }

    private String generatePassword() {
        return UUID.randomUUID().toString() + "ABab23!";
    }

    private Optional<JitCrowdUser> findUserInInternalDirectoryByName(JitUserData jitUserData) {
        List<Directory> internalActiveDirectories = this.getAllActiveInternalDirectories();
        return this.searchForUserInDirectories(jitUserData, internalActiveDirectories);
    }

    @NotNull
    private Optional<JitCrowdUser> searchForUserInDirectories(JitUserData jitUserData, List<Directory> internalActiveDirectories) {
        if (!internalActiveDirectories.isEmpty()) {
            try {
                EntityQuery<User> userQuery = this.createByUsernameQuery(jitUserData);
                for (Directory directory : internalActiveDirectories) {
                    List result = this.directoryManager.searchUsers(directory.getId().longValue(), userQuery);
                    if (!result.iterator().hasNext()) continue;
                    return Optional.of(new JitCrowdUser(null, (User)result.iterator().next()));
                }
                return Optional.empty();
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new JitException(e);
            }
        }
        throw new JitException("Could not find any writable active internal directories");
    }

    private EntityQuery<User> createByUsernameQuery(JitUserData jitUserData) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)jitUserData.getUsername())).startingAt(0).returningAtMost(1);
    }

    @NotNull
    private List<Directory> getAllActiveInternalDirectories() {
        return this.directoryManager.searchDirectories(ProvisioningService.allDirectoriesQuery()).stream().filter(d -> d.getType().equals((Object)DirectoryType.INTERNAL)).filter(Directory::isActive).collect(Collectors.toList());
    }

    private Optional<JitCrowdUser> getUserByIdentityProviderId(String identityProviderId) {
        Iterable result = this.crowdService.search(this.createQueryForUserByIdpId(identityProviderId));
        return result.iterator().hasNext() ? Optional.of(new JitCrowdUser(identityProviderId, (User)result.iterator().next())) : Optional.empty();
    }

    private EntityQuery<User> createQueryForUserByIdpId(String identityProviderId) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"jit_idp_id")).exactlyMatching((Object)identityProviderId)).returningAtMost(1);
    }

    private static EntityQuery<Directory> allDirectoriesQuery() {
        return QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1);
    }

    public static interface DarkFeature {
        public static final String DISABLE_LICENSE_CHECK = "atlassian.authentication.sso.jit.disable.license.check";
    }
}

