/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.plugins.authentication.impl.config.AbstractSsoConfigValidator;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.ValidationError;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ValidationUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SamlConfigValidator
extends AbstractSsoConfigValidator<SamlConfig> {
    @Inject
    public SamlConfigValidator(HttpsValidator httpsValidator) {
        super(httpsValidator);
    }

    @Override
    protected SsoType getSsoType() {
        return SsoType.SAML;
    }

    @Override
    protected Class<SamlConfig> getSsoClass() {
        return SamlConfig.class;
    }

    @Override
    protected void validate(@Nonnull ImmutableMultimap.Builder<String, ValidationError> errors, @Nonnull SamlConfig samlConfig) {
        String ssoUrlField = samlConfig.getIdpType() == SamlConfig.IdpType.CROWD ? "crowd-url" : "sso-url";
        String ssoIssuerField = samlConfig.getIdpType() == SamlConfig.IdpType.CROWD ? "crowd-url" : "sso-issuer";
        errors.putAll((Object)ssoUrlField, this.validateRequiredField(samlConfig.getSsoUrl()));
        errors.putAll((Object)ssoIssuerField, this.validateRequiredField(samlConfig.getSsoIssuer()));
        errors.putAll((Object)"certificate", this.validateRequiredField(samlConfig.getCertificate()));
        errors.putAll((Object)"idp-type", this.validateIdpType(samlConfig.getIdpType(), samlConfig.getInferredIdpType()));
        errors.putAll((Object)ssoUrlField, this.validateUrl(samlConfig.getSsoUrl()));
        errors.putAll((Object)"certificate", this.validateCertificate(samlConfig.getCertificate()));
        if (samlConfig.getIdpType().equals((Object)SamlConfig.IdpType.GENERIC)) {
            errors.putAll((Object)"user-attribute", this.validateMappingExpression(samlConfig.getUsernameAttribute()));
            errors.putAll(this.validateJitFields(samlConfig.getJustInTimeConfig()));
        }
    }

    private Iterable<? extends ValidationError> validateIdpType(SamlConfig.IdpType actualIdpType, SamlConfig.IdpType inferredIdpType) {
        if (inferredIdpType == actualIdpType) {
            return NO_ERRORS;
        }
        if (actualIdpType == SamlConfig.IdpType.GENERIC && inferredIdpType == SamlConfig.IdpType.CROWD) {
            return NO_ERRORS;
        }
        return ERROR_INCORRECT;
    }

    private Iterable<ValidationError> validateCertificate(String certificateString) {
        if (!Strings.isNullOrEmpty((String)certificateString)) {
            try {
                ValidationUtils.convertToCertificate(certificateString);
            }
            catch (Exception e) {
                return ERROR_INCORRECT;
            }
        }
        return NO_ERRORS;
    }
}

