/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.usercontext.impl;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.PrincipalResolver;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.user.UserManager;
import java.security.Principal;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

@BambooComponent
public class SalPrincipalResolver
implements PrincipalResolver {
    private final UserManager userManager;
    private final AuthenticationController authenticationController;

    @Inject
    public SalPrincipalResolver(@ComponentImport UserManager userManager, @ComponentImport AuthenticationController authenticationController) {
        this.userManager = userManager;
        this.authenticationController = authenticationController;
    }

    @Override
    public Principal resolvePrincipal(String username, HttpServletRequest request) throws AuthenticationFailedException {
        Principal resolvedUser = this.resolvePrincipal(username);
        if (resolvedUser == null) {
            throw new AuthenticationFailedException("Received SSO request for user " + username + ", but the user doesn't exist in the product");
        }
        if (!this.isAllowedToLogin(request, resolvedUser)) {
            throw new AuthenticationFailedException("Received SSO request for user " + username + ", but the user is not permitted to log in");
        }
        return resolvedUser;
    }

    protected Principal resolvePrincipal(String username) {
        return this.userManager.resolve(username);
    }

    protected boolean isAllowedToLogin(HttpServletRequest request, Principal resolvedUser) {
        return this.authenticationController.canLogin(resolvedUser, request);
    }
}

