/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.filter.logout.LogoutFilter;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraServiceDeskLogoutFilter
extends LogoutFilter {
    public static final String SD_LOGOUT_QUERY_PARAM = "sd-logout";
    static final String XHR_HEADER_VALUE = "XMLHttpRequest";
    static final String XHR_HEADER_NAME = "X-Requested-With";
    private final SessionDataService sessionDataService;

    @Inject
    public JiraServiceDeskLogoutFilter(SessionDataService sessionDataService, @ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService) {
        super(applicationProperties, ssoConfigService);
        this.sessionDataService = sessionDataService;
    }

    @Override
    protected boolean shouldRequestBeRedirected(HttpServletRequest request) {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        return ssoConfig != null && ssoConfig.isIncludeCustomerLogins() && (this.sessionDataService.wasLoggedOutFromSdCustomerPortal(request) || Boolean.parseBoolean(request.getParameter("logout")));
    }

    @Override
    protected void redirectToSsoLogoutPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.wasRequestedByAjax(request)) {
            this.sessionDataService.setLoggedOutFromSdCustomerPortal(request, false);
        }
        response.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/sso-logout" + "?" + SD_LOGOUT_QUERY_PARAM + "=" + true);
    }

    private boolean wasRequestedByAjax(HttpServletRequest request) {
        return XHR_HEADER_VALUE.equals(request.getHeader(XHR_HEADER_NAME));
    }
}

