/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.impl.web.InvalidLicenseException;
import com.atlassian.plugins.authentication.impl.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlingFilter.class);
    private static final String INCLUDE_STACKTRACE_DARKFEATURE = "atlassian.authentication.include.stacktrace.in.error.messages";
    public static final String TEMPLATE_COMPLETE_KEY = "com.atlassian.plugins.authentication.atlassian-authentication-plugin:templates";
    public static final String INVALID_SAML_RESPONSE_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.InvalidSamlResponse.display";
    public static final String AUTHENTICATION_FAILED_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.AuthenticationFailed.display";
    public static final String AUTHENTICATION_NOT_CONFIGURED_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.AuthenticationNotConfigured.display";
    private static final String RESPONSE_CONTENT_TYPE = "text/html";
    private final SoyTemplateRenderer templateRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;
    private final DarkFeatureManager darkFeatureManager;

    public ErrorHandlingFilter(@ComponentImport SoyTemplateRenderer templateRenderer, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.templateRenderer = templateRenderer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
        this.darkFeatureManager = darkFeatureManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (AuthenticationHandlerNotConfiguredException | InvalidLicenseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.renderResponse(response, AUTHENTICATION_NOT_CONFIGURED_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of(), e);
        }
        catch (InvalidSamlResponse e) {
            log.error(e.getMessage(), (Throwable)e);
            this.renderResponse(response, INVALID_SAML_RESPONSE_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of((Object)"url", (Object)this.prepareTargetUrl(e.getTargetUrl()), (Object)"productName", (Object)this.applicationProperties.getDisplayName()), e);
        }
        catch (AuthenticationFailedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.renderResponse(response, AUTHENTICATION_FAILED_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of(), e);
        }
    }

    public void destroy() {
    }

    private void renderResponse(HttpServletResponse responseToFill, String templateNameWithNamespace, int statusCode, Map<String, Object> customMappings, Throwable error) throws IOException {
        responseToFill.setContentType(RESPONSE_CONTENT_TYPE);
        responseToFill.setStatus(statusCode);
        this.templateRenderer.render((Appendable)responseToFill.getWriter(), TEMPLATE_COMPLETE_KEY, templateNameWithNamespace, this.prepareMappings(customMappings, error));
    }

    private Map<String, Object> prepareMappings(Map<String, Object> customMappings, Throwable error) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (this.shouldIncludeStackTrace()) {
            mapBuilder.put((Object)"stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)error));
        }
        mapBuilder.put((Object)"errorImgUrl", (Object)this.webResourceUrlProvider.getStaticPluginResourceUrl(TEMPLATE_COMPLETE_KEY, "error", UrlMode.RELATIVE)).putAll(customMappings);
        return mapBuilder.build();
    }

    public String prepareTargetUrl(@Nullable String redirectUrl) {
        try {
            if (redirectUrl != null) {
                return this.loginUriProvider.getLoginUri(new URI(redirectUrl)).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return this.applicationProperties.getBaseUrl(com.atlassian.sal.api.UrlMode.RELATIVE) + "/plugins/servlet/external-login";
    }

    private boolean shouldIncludeStackTrace() {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(INCLUDE_STACKTRACE_DARKFEATURE);
    }
}

