/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.impl.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationRequest;
import com.atlassian.plugins.authentication.impl.web.SessionData;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private static final int COOKIE_WITH_FRAGMENT_MAXIMUM_AGE_MINUTES = 5;
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthenticationHandler.class);
    protected final ApplicationProperties applicationProperties;
    protected final ApplicationStateValidator applicationStateValidator;
    protected final SessionDataService sessionDataService;
    protected final TargetUrlNormalizer targetUrlNormalizer;
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected final SoyTemplateRenderer soyTemplateRenderer;

    protected AbstractAuthenticationHandler(ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, SessionDataService sessionDataService, TargetUrlNormalizer targetUrlNormalizer, WebResourceUrlProvider webResourceUrlProvider, SoyTemplateRenderer soyTemplateRenderer) {
        this.applicationProperties = applicationProperties;
        this.applicationStateValidator = applicationStateValidator;
        this.sessionDataService = sessionDataService;
        this.targetUrlNormalizer = targetUrlNormalizer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    @Nonnull
    public String getIssuerUrl() {
        return this.applicationProperties.getBaseUrl(com.atlassian.sal.api.UrlMode.CANONICAL);
    }

    @Override
    public void processAuthenticationRequest(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable String destinationUrl) throws IOException {
        this.processAuthenticationRequestForRelativeDestinationUrl(request, response, this.targetUrlNormalizer.getRelativeTargetUrl(destinationUrl));
    }

    @VisibleForTesting
    public void processAuthenticationRequestForRelativeDestinationUrl(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable URI relativeDestinationUri) throws IOException {
        this.applicationStateValidator.checkCanProcessAuthenticationRequest();
        this.sessionDataService.ensureSessionExists(request);
        AuthenticationRequest authnRequest = this.prepareAuthenticationRequest(request, response);
        this.sessionDataService.setSessionData(request, authnRequest.getSessionDataKey(), new SessionData(authnRequest, relativeDestinationUri));
        if (relativeDestinationUri == null) {
            response.sendRedirect(authnRequest.getLoginRequestUrl());
        } else {
            this.renderFragmentSavingPage(response, authnRequest.getLoginRequestUrl(), authnRequest.getPublicId());
        }
    }

    @Override
    public boolean isCorrectlyConfigured() {
        return this.applicationStateValidator.canProcessAuthenticationRequest();
    }

    protected abstract AuthenticationRequest prepareAuthenticationRequest(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2);

    protected boolean isPermissionViolation(HttpServletRequest request) {
        if (this.sessionDataService.isUserLoggedInWithSso(request)) {
            log.info("User is already logged in. Looks like permissions violation. Force re-authentication in IDP");
            return true;
        }
        return false;
    }

    private void renderFragmentSavingPage(@Nonnull HttpServletResponse resp, @Nonnull String loginRequestUrl, @Nonnull String cookieSuffix) throws IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding("utf-8");
        this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.plugins.authentication.atlassian-authentication-plugin:save-fragment", "AuthenticationPlugin.SaveHash.display", (Map)ImmutableMap.of((Object)"idpRequest", (Object)loginRequestUrl, (Object)"cookieName", (Object)("atlassian-authentication-plugin-url-fragment_" + cookieSuffix), (Object)"cookiePath", (Object)this.applicationProperties.getBaseUrl(com.atlassian.sal.api.UrlMode.RELATIVE), (Object)"cookieExpirationTimeInMinutesFromNow", (Object)5, (Object)"jsCookieLibraryUrl", (Object)this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.plugins.authentication.atlassian-authentication-plugin:save-fragment", "js.cookie.js", UrlMode.RELATIVE)));
    }
}

