/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.event.SsoConfigUpdatedEvent;
import com.atlassian.plugins.authentication.event.SsoDisabledEvent;
import com.atlassian.plugins.authentication.event.SsoEnabledEvent;
import com.atlassian.plugins.authentication.impl.config.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.InvalidConfigException;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigDao;
import com.atlassian.plugins.authentication.impl.config.SsoConfigValidatorProvider;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.impl.web.oidc.OidcDiscoveryException;
import com.atlassian.plugins.authentication.impl.web.oidc.OidcDiscoverySupport;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SsoConfigService {
    private static final Logger logger = LoggerFactory.getLogger(SsoConfigService.class);
    private final EventPublisher eventPublisher;
    private final SsoConfigDao ssoConfigDao;
    private final SsoConfigValidatorProvider ssoConfigValidatorProvider;
    private final OidcDiscoverySupport oidcDiscoverySupport;

    @Inject
    public SsoConfigService(@ComponentImport EventPublisher eventPublisher, SsoConfigDao ssoConfigDao, SsoConfigValidatorProvider ssoConfigValidatorProvider, OidcDiscoverySupport oidcDiscoverySupport) {
        this.eventPublisher = eventPublisher;
        this.ssoConfigDao = ssoConfigDao;
        this.ssoConfigValidatorProvider = ssoConfigValidatorProvider;
        this.oidcDiscoverySupport = oidcDiscoverySupport;
    }

    @Nonnull
    public SsoType getSsoType() {
        return this.ssoConfigDao.getSsoType();
    }

    @Nullable
    public SsoConfig getSsoConfig() {
        return this.ssoConfigDao.getSsoConfig();
    }

    public void updateSsoConfig(@Nonnull SsoConfig newConfig) {
        Objects.requireNonNull(newConfig, "SSO configuration cannot be null");
        this.updateSsoConfigInternal(this.getSsoConfig(), this.refreshDiscoveryIfNeeded(newConfig));
    }

    public void refreshSsoConfig() {
        SsoConfig currentConfig = this.getSsoConfig();
        if (currentConfig != null) {
            this.updateSsoConfigInternal(currentConfig, this.refreshDiscoveryIfNeeded(currentConfig));
        }
    }

    private void updateSsoConfigInternal(@Nullable SsoConfig previousConfig, @Nonnull SsoConfig newConfig) {
        if (Objects.equals(newConfig, previousConfig)) {
            return;
        }
        Multimap<String, ErrorReason> errorsOnFields = this.ssoConfigValidatorProvider.getValidatorUnchecked(newConfig.getSsoType()).validate(newConfig);
        if (!errorsOnFields.isEmpty()) {
            throw new InvalidConfigException(errorsOnFields);
        }
        this.ssoConfigDao.saveSsoConfig(newConfig);
        this.publishEventsIfConfigChanged(newConfig, previousConfig);
    }

    private SsoConfig refreshDiscoveryIfNeeded(SsoConfig newConfig) {
        Optional<OidcConfig> oidcConfig = OidcConfig.from(newConfig).filter(OidcConfig::isDiscoveryEnabled);
        if (oidcConfig.isPresent()) {
            try {
                return this.oidcDiscoverySupport.refresh(oidcConfig.get());
            }
            catch (OidcDiscoveryException e) {
                logger.info("Failed fetching metadata from OIDC discovery, issuer: {}.", (Object)oidcConfig.get().getIssuerUrl(), (Object)e);
                throw new InvalidConfigException((Multimap<String, ErrorReason>)ImmutableMultimap.of((Object)"discovery-enabled", (Object)((Object)ErrorReason.INCORRECT)));
            }
        }
        return newConfig;
    }

    public void disableSso() {
        this.ssoConfigDao.removeSsoConfig();
        this.eventPublisher.publish((Object)new SsoDisabledEvent());
    }

    private void publishEventsIfConfigChanged(@Nonnull SsoConfig newConfig, @Nullable SsoConfig previousSsoConfig) {
        if (previousSsoConfig == null || previousSsoConfig.isRedirectOnLogin() != newConfig.isRedirectOnLogin()) {
            this.eventPublisher.publish((Object)new SsoEnabledEvent(newConfig.isRedirectOnLogin()));
        }
        this.eventPublisher.publish((Object)new SsoConfigUpdatedEvent());
    }

    @Nonnull
    public OidcConfig getOidcConfigOrFail() {
        return OidcConfig.from(this.getSsoConfig()).orElseThrow(() -> new AuthenticationHandlerNotConfiguredException("SSO is not configured for OpenID Connect"));
    }

    @Nonnull
    public SamlConfig getSamlConfigOrFail() {
        return SamlConfig.from(this.getSsoConfig()).orElseThrow(() -> new AuthenticationHandlerNotConfiguredException("SSO is not configured for SAML"));
    }
}

