/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.analytics.events.AbstractStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.AllowRedirectOverrideStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.ConfiguredAuthenticationMethodStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.IdpProviderStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.RedirectOnLoginStatusEvent;
import com.atlassian.plugins.authentication.impl.analytics.events.ServiceDeskCustomerLoginStatusEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class StatisticsCollectionService
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(StatisticsCollectionService.class);
    private static final JobRunnerKey JOBRUNNER_KEY = JobRunnerKey.of((String)StatisticsCollectionService.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"analytics-collection");
    private static final String COLLECTION_SCHEDULE = "0 0 23 * * ?";
    private static final String DEBUG_COLLECTION_SCHEDULE = "0/30 * * * * ?";
    public static final String DEBUG_ANALYTICS_SYSTEM_PROPERTY = "atlassian.authentication.debug.analytics";
    private final SchedulerService schedulerService;
    private final ApplicationProperties applicationProperties;
    private final SsoConfigService ssoConfigService;
    private final EventPublisher eventPublisher;
    private ProductLicenseDataProvider productLicenseDataProvider;

    @Inject
    public StatisticsCollectionService(@ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService, @ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService, ProductLicenseDataProvider productLicenseDataProvider) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
        this.applicationProperties = applicationProperties;
        this.ssoConfigService = ssoConfigService;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    @PostConstruct
    public void register() throws SchedulerServiceException {
        try {
            Class.forName("com.atlassian.analytics.api.annotations.EventName");
        }
        catch (ClassNotFoundException e) {
            log.debug("No analytics api, not registering analytics collection");
            return;
        }
        this.schedulerService.registerJobRunner(JOBRUNNER_KEY, (JobRunner)this);
        String collectionSchedule = Boolean.getBoolean(DEBUG_ANALYTICS_SYSTEM_PROPERTY) ? DEBUG_COLLECTION_SCHEDULE : COLLECTION_SCHEDULE;
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOBRUNNER_KEY).withSchedule(Schedule.forCronExpression((String)collectionSchedule)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        log.debug("Registered analytics collection job with schedule " + collectionSchedule);
    }

    @PreDestroy
    public void unregister() {
        this.schedulerService.unregisterJobRunner(JOBRUNNER_KEY);
        log.debug("Unregistered analytics collection job");
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        String platformId = this.applicationProperties.getPlatformId();
        log.debug("Collecting configuration statistics");
        Stream.of(new ConfiguredAuthenticationMethodStatusEvent(ssoConfig, platformId), new AllowRedirectOverrideStatusEvent(ssoConfig, platformId), new IdpProviderStatusEvent(ssoConfig, platformId), new RedirectOnLoginStatusEvent(ssoConfig, platformId), new ServiceDeskCustomerLoginStatusEvent(ssoConfig, platformId, this.productLicenseDataProvider)).forEach(this::tryPublish);
        return JobRunnerResponse.success();
    }

    private void tryPublish(AbstractStatusEvent event) {
        try {
            if (event.shouldCollect()) {
                log.debug("Publishing " + event.getClass().getSimpleName());
                this.eventPublisher.publish((Object)event);
            }
        }
        catch (Exception e) {
            log.info("Error collecting analytics data", (Throwable)e);
        }
    }
}

