define('atlassian-authentication-plugin/configForm', ['jquery'], function ($) {
    function ConfigForm() {
        var self = null;
        return {
            init: function () {
                self = this;
                self.configForm = $('#configForm');
                self.currentForm = null;
                self.initializeForm();
                self.initializeCopyButtons();
            },
            getSelectedContainer: function() {
              var currentId;
              $("#js-authentication-methods input[type='radio']").each(function() {
                if ($(this).is(":checked")) currentId = $(this).attr("data-form");
              })
              return $("#" + currentId);
            },
            showFlag: function (type, title, body, autoClose) {
                window.require(['aui/flag'], function (flag) {
                    flag({
                        type: type,
                        title: title,
                        close: autoClose ? "auto" : "manual",
                        body: body ? '<p>' + body + '</p>' : null
                    });
                });
            },
            initializeCopyButtons: function () {
              $(".idp-copy").click(function () {
                var inputId = $(this).attr("data-clipboard-target")
                var input = document.querySelector(inputId)
                input.removeAttribute("readonly")
                input.select()
                if (window.clipboardData) {
                  window.clipboardData.setData('Text', input.value)
                } else {
                  document.execCommand('copy')
                }
                input.setAttribute("readonly", "true")
                self.showFlag('success', AJS.I18n.getText('authentication.copy.success'), null, true);
              })
            },
            initializeForm: function () {
                function errorOnFieldTemplate(message) {
                    return AJS.template.load('error-on-field-template').fill({message: message}).toString();
                }

                initializeSubmitBehaviour();
                self.hideFormIfAlreadyDisabled((self.configForm.data('issecurebaseurl') || self.configForm.data('skiphttps')));
                self.initializeRadioButtonsBehaviour();

                function initializeSubmitBehaviour() {
                    self.configForm.submit(function (ev) {
                        clearErrors(self.configForm);
                        ev.preventDefault();
                        var newConfig;
                        var isNativeAuthenticationChosen = self.configForm.find('#native-authentication').is(':checked');
                        var method;
                        if (isNativeAuthenticationChosen) {
                            method = 'DELETE';
                            self.clearForm(self.configForm)
                        } else {
                            method = 'PUT';
                            newConfig = loadNewConfiguration(self.configForm);
                        }
                        $.ajax({
                            type: method,
                            url: self.configForm.attr('action'),
                            contentType: 'application/json',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('X-Atlassian-Token', 'no-check');
                            },
                            data: JSON.stringify(newConfig),
                            dataType: 'json',
                            accept: 'application/json'
                        })
                          .done(function (data, textStatus, jqXHR) {
                              self.showFlag('success', AJS.I18n.getText('authentication.config.save.success'), null, true);
                          })
                            .fail(function (jqXHR, textStatus, errorThrown) {
                                try {
                                    var error = JSON.parse(jqXHR.responseText);
                                    if (error.message) {
                                        self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), error.message);
                                    } else if (error.errors) {
                                        self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), AJS.I18n.getText('authentication.config.invalid.error.body'))
                                        for (var key in error.errors) {
                                            for (var i in error.errors[key]) {
                                                addFieldError(key, error.errors[key][i]);
                                            }
                                        }
                                    }
                                    else {
                                        showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), AJS.I18n.getText('authentication.config.save.fail.unknown.reason'))
                                    }
                                } catch (exception) {
                                    self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), errorThrown);
                                }
                            });
                    });

                    function addFieldError(fieldId, message) {
                      var dataForm = self.getSelectedContainer()
                        dataForm.find(".js-" + fieldId).after(errorOnFieldTemplate(message))
                    }

                    function loadNewConfiguration() {
                      var selector = self.getSelectedContainer();
                      var issuer = selector.find('.js-sso-issuer').val();
                      var id = selector.attr("id");
                      var options = {};
                      switch(id) {
                        case "js-saml-form":
                          options['idp-type'] = "GENERIC";
                          options["sso-issuer"] = issuer;
                          options["sso-url"] = selector.find('.js-sso-url').val()
                          break;
                        case "js-crowd-form":
                          options['idp-type'] = "CROWD";
                          options["crowd-url"] = issuer;
                          break;
                      }
                      return $.extend({}, options, {
                          'redirect-on-login': selector.find('.js-redirect-on-login').is(':checked'),
                          'certificate': selector.find('.js-certificate').val(),
                          'include-customer-logins': selector.find('.js-include-customer-logins').prop("checked"),
                          'enable-remember-me': selector.find('.js-enable-remember-me').prop("checked")
                      });
                    }

                    function clearErrors() {
                        self.configForm.find('.error').remove();
                    }
                }
            },
            hideFormIfAlreadyDisabled: function (shouldBeEnabled) {
              if (!shouldBeEnabled) {
                  self.configForm.find('#native-authentication').prop('checked', 'true');
                  self.configForm.find('#saml-authentication, #crowd-authentication').prop('disabled', 'true');
                  self.configForm.find('#saml-save').prop('disabled', 'true');

                  self.setFormEditabilityAndVisibility(false, false);
              }
            },
            initializeRadioButtonsBehaviour: function () {
                self.configForm.find('#native-authentication').change(function () {
                    self.setFormEditabilityAndVisibilityIfChecked($(this), false)
                });

                self.configForm.find('#saml-authentication').change(function () {
                    self.setFormEditabilityAndVisibilityIfChecked($(this), true)
                });

                self.configForm.find('#crowd-authentication').change(function () {
                  self.setFormEditabilityAndVisibilityIfChecked($(this), true)
              });
            },
            setFormEditabilityAndVisibilityIfChecked: function ($radio, visibleIfChecked) {
              var checked = $radio.is(':checked');
              if (checked) {
                $(".form-hideable").addClass("form-hidden");
                $("#" + $radio.attr("data-form")).removeClass("form-hidden");
              }
            },
            setFormEditabilityAndVisibility: function (editable, visible) {
                self.configForm.find('#sso-config .disableable').prop('disabled', !editable);
                self.configForm.find('.form-hideable').toggleClass("form-hidden", !visible);
            },
            clearForm: function () {
                self.configForm.find('input[type=text]:not([readonly]), textarea').val('');
                self.configForm.find('.js-include-customer-logins').prop('checked', false);
                self.configForm.find('#allow-saml-redirect-override').prop('checked', false);
                self.configForm.find('.js-dont-redirect-on-login').prop('checked', true);
                self.configForm.find('#enable-remember-me').prop('checked', true);
            }
        };
    }

    window.SAMLAuthPlugin = window.SAMLAuthPlugin || {};
    window.SAMLAuthPlugin.ConfigForm = window.SAMLAuthPlugin.ConfigForm || ConfigForm();

    return window.SAMLAuthPlugin.ConfigForm;
});

require(['jquery', 'atlassian-authentication-plugin/configForm'], function ($, ConfigForm) {
    $(ConfigForm.init.bind(ConfigForm));
    window.ConfigForm = ConfigForm
});

