/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.authentication;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.AuthenticationConfig;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.filter.authentication.AuthenticationFilter;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;

public class ServiceDeskAuthenticationFilter
extends AuthenticationFilter {
    public static final String SERVICE_DESK_DESTINATION_QUERY_PARAM = "destination";
    public static final String SERVICE_DESK_PSEUDO_ABSOLUTE_REDIRECT_QUERY_PARAM = "absolute";

    public ServiceDeskAuthenticationFilter(AuthenticationConfig authenticationConfig, AuthenticationHandler authenticationHandler, @ComponentImport ApplicationProperties applicationProperties) {
        super(authenticationConfig, authenticationHandler, applicationProperties);
    }

    @Override
    @Nullable
    protected String extractRequestedUrl(HttpServletRequest req) {
        String destination = Strings.emptyToNull((String)req.getParameter(SERVICE_DESK_DESTINATION_QUERY_PARAM));
        if (destination == null) {
            return null;
        }
        URI targetUrl = this.validateUri(destination);
        if (Boolean.valueOf(req.getParameter(SERVICE_DESK_PSEUDO_ABSOLUTE_REDIRECT_QUERY_PARAM)).booleanValue()) {
            return this.removeContextPathFromUriIfNeeded(targetUrl).toString();
        }
        return UriBuilder.fromUri((URI)targetUrl).replacePath("").path("/servicedesk/customer").path(targetUrl.getPath()).build(new Object[0]).toString();
    }

    @Override
    protected boolean shouldAttemptAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException, URISyntaxException {
        return super.shouldAttemptAuthentication(req, resp) && this.authenticationConfig.isIncludeCustomerLogins();
    }
}

