/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.authentication;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.AuthenticationConfig;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
implements Filter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ATLASSIAN_RECOVERY_PASSWORD = "atlassian.recovery.password";
    private static final Set<String> ILLEGAL_DESTINATION_URLS = ImmutableSet.of((Object)"/plugins/servlet/samlconsumer", (Object)"/plugins/servlet/saml-logout");
    private final AuthenticationHandler authenticationHandler;
    protected final ApplicationProperties applicationProperties;
    protected final AuthenticationConfig authenticationConfig;

    public AuthenticationFilter(AuthenticationConfig authenticationConfig, AuthenticationHandler authenticationHandler, @ComponentImport ApplicationProperties applicationProperties) {
        this.authenticationConfig = authenticationConfig;
        this.authenticationHandler = authenticationHandler;
        this.applicationProperties = applicationProperties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            if (!this.shouldAttemptAuthentication(req, resp)) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            URI destinationUri = this.getTargetUrl(req);
            this.authenticationHandler.processAuthenticationRequest(req, resp, destinationUri);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            resp.sendError(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
        }
    }

    protected boolean shouldAttemptAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException, URISyntaxException {
        if (this.authenticationConfig.isSkipExternalAuthentication(req, resp)) {
            this.log.trace("Not attempting external authentication, prevented by AuthenticationConfig");
            return false;
        }
        if (!this.authenticationHandler.isCorrectlyConfigured()) {
            this.log.trace("Not attempting external authentication, AuthenticationHandler not configured");
            return false;
        }
        if (System.getProperty(ATLASSIAN_RECOVERY_PASSWORD) != null) {
            this.log.trace("Not attempting external authentication, Atlassian password recovery set");
            return false;
        }
        return true;
    }

    private URI getTargetUrl(HttpServletRequest req) {
        URI uri;
        String targetUrl = this.extractRequestedUrl(req);
        if (targetUrl != null && !ILLEGAL_DESTINATION_URLS.contains((uri = this.validateUri(targetUrl.replace(" ", "+"))).getPath())) {
            return uri;
        }
        return null;
    }

    @Nullable
    protected abstract String extractRequestedUrl(HttpServletRequest var1);

    protected URI validateUri(String targetUrl) {
        try {
            URI normalizedUri = new URI(targetUrl).normalize();
            URI relativizedAndNormalizedUri = this.relativizeUriIfNeeded(normalizedUri);
            Preconditions.checkArgument((!relativizedAndNormalizedUri.getPath().startsWith("../") ? 1 : 0) != 0, (Object)("Requested path traversal outside the context path " + targetUrl + ", aborting"));
            return relativizedAndNormalizedUri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error parsing provided url " + targetUrl + ", aborting", e);
        }
    }

    private URI relativizeUriIfNeeded(URI targetUri) throws URISyntaxException {
        URI result;
        if (targetUri.isAbsolute() || Strings.emptyToNull((String)targetUri.getHost()) != null || targetUri.getPort() != -1 || Strings.emptyToNull((String)targetUri.getUserInfo()) != null || Strings.emptyToNull((String)targetUri.getAuthority()) != null) {
            URI relativizedUrl = UriBuilder.fromUri((String)"").replacePath(targetUri.getPath()).replaceQuery(targetUri.getRawQuery()).fragment(targetUri.getFragment()).build(new Object[0]);
            result = this.removeContextPathFromUriIfNeeded(relativizedUrl);
        } else {
            result = targetUri;
        }
        return result;
    }

    protected URI removeContextPathFromUriIfNeeded(URI targetUri) {
        String contextPath = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String urlAsString = targetUri.toString();
        if (urlAsString.startsWith(contextPath)) {
            return UriBuilder.fromUri((String)urlAsString.substring(contextPath.length(), urlAsString.length())).build(new Object[0]);
        }
        return targetUri;
    }

    public void destroy() {
    }
}

