/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.saml;

import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.rest.saml.model.SamlConfigEntity;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/saml")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class SamlConfigResource {
    private final SamlConfigService configService;
    private final ApplicationStateValidator applicationStateValidator;

    @Inject
    public SamlConfigResource(SamlConfigService configService, ApplicationStateValidator applicationStateValidator) {
        this.configService = configService;
        this.applicationStateValidator = applicationStateValidator;
    }

    @GET
    public SamlConfigEntity getConfig() {
        return new SamlConfigEntity(this.configService.getSamlConfig());
    }

    @DELETE
    public void disableSaml() {
        this.configService.disable();
    }

    @PUT
    public SamlConfigEntity updateConfig(SamlConfigEntity newConfig) {
        SamlConfig config = this.configService.getSamlConfig().toBuilder().updateNonNull(newConfig).build();
        this.applicationStateValidator.validateConfig(config);
        this.configService.updateConfig(config);
        return new SamlConfigEntity(this.configService.getSamlConfig());
    }
}

