/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.ui.WhitelistBean;
import com.atlassian.plugins.whitelist.ui.WhitelistBeanService;
import com.atlassian.plugins.whitelist.ui.WhitelistRuleComparator;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WhitelistBeanServiceImpl
implements WhitelistBeanService {
    private static final Logger logger = LoggerFactory.getLogger(WhitelistBeanServiceImpl.class);
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final WhitelistService whitelistService;
    private WhitelistRuleComparator whitelistRuleComparator;
    private final ImmutableMap<WhitelistType, Function<WhitelistRule, WhitelistBean>> mappings = ImmutableMap.of((Object)WhitelistType.APPLICATION_LINK, this.createApplicationLinkRule(), (Object)WhitelistType.EXACT_URL, this.createUrlExpressionRule(), (Object)WhitelistType.WILDCARD_EXPRESSION, this.createUrlExpressionRule(), (Object)WhitelistType.REGULAR_EXPRESSION, this.createUrlExpressionRule(), (Object)WhitelistType.DOMAIN_NAME, this.createUrlExpressionRule());

    public WhitelistBeanServiceImpl(ReadOnlyApplicationLinkService applicationLinkService, WhitelistService whitelistService, WhitelistRuleComparator whitelistRuleComparator) {
        this.applicationLinkService = applicationLinkService;
        this.whitelistService = whitelistService;
        this.whitelistRuleComparator = whitelistRuleComparator;
    }

    @Override
    public WhitelistBean add(WhitelistBean whitelistBean) {
        return this.asBean(this.whitelistService.add(whitelistBean.asRule()));
    }

    @Override
    public WhitelistBean update(int id, WhitelistBean whitelistBean) {
        WhitelistRule existingWhitelistRule = this.whitelistService.get(id);
        Preconditions.checkNotNull((Object)existingWhitelistRule, (Object)("Whitlist rule with id '" + id + "' not existing."));
        WhitelistRule updatedRule = whitelistBean.populateWith(existingWhitelistRule);
        WhitelistRule whitelistRule = this.whitelistService.update(updatedRule);
        return this.asBean(whitelistRule);
    }

    @Override
    public List<WhitelistBean> getAll() {
        return this.asBeans((List<WhitelistRule>)Ordering.from((Comparator)this.whitelistRuleComparator).immutableSortedCopy((Iterable)this.whitelistService.getAll()));
    }

    private List<WhitelistBean> asBeans(List<WhitelistRule> whitelistRules) {
        return ImmutableList.copyOf((Collection)Collections2.filter((Collection)Lists.transform(whitelistRules, this.asBean()), (Predicate)Predicates.notNull()));
    }

    private WhitelistBean asBean(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        WhitelistType type = whitelistRule.getType();
        Function whitelistRuleDataWhitelistBeanFunction = (Function)this.mappings.get((Object)type);
        if (whitelistRuleDataWhitelistBeanFunction == null) {
            logger.warn("No mapping found for whitelist type '{}', ignoring data '{}'.", (Object)type, (Object)whitelistRule);
            return null;
        }
        return (WhitelistBean)whitelistRuleDataWhitelistBeanFunction.apply((Object)whitelistRule);
    }

    private Function<WhitelistRule, WhitelistBean> asBean() {
        return new Function<WhitelistRule, WhitelistBean>(){

            public WhitelistBean apply(@Nullable WhitelistRule input) {
                if (input == null) {
                    return null;
                }
                return WhitelistBeanServiceImpl.this.asBean(input);
            }
        };
    }

    private Function<WhitelistRule, WhitelistBean> createApplicationLinkRule() {
        return new Function<WhitelistRule, WhitelistBean>(){

            public WhitelistBean apply(WhitelistRule input) {
                String applicationId = input.getExpression();
                ReadOnlyApplicationLink applicationLink = WhitelistBeanServiceImpl.this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
                if (applicationLink == null) {
                    logger.warn("Failed to resolved application link with application id '" + applicationId + "'; maybe it has been removed and the whitelist was not updated?");
                    return null;
                }
                String applicationLinkName = applicationLink.getName();
                URI displayUrl = applicationLink.getDisplayUrl();
                URI iconUrl = applicationLink.getType().getIconUrl();
                return WhitelistBean.builder().id(input.getId()).expression(String.format("%s (%s)", applicationLinkName, displayUrl.toString())).type(WhitelistType.APPLICATION_LINK).iconUrl(iconUrl != null ? iconUrl.toString() : "").allowInbound(input.isAllowInbound()).build();
            }
        };
    }

    private Function<WhitelistRule, WhitelistBean> createUrlExpressionRule() {
        return new Function<WhitelistRule, WhitelistBean>(){

            public WhitelistBean apply(WhitelistRule input) {
                return WhitelistBean.builder().from(input).iconUrl(WhitelistBeanServiceImpl.this.generateIconUrl(input, "")).build();
            }
        };
    }

    private String generateIconUrl(WhitelistRule whitelistRule, String defaultIconUrl) {
        if (whitelistRule.getType() == WhitelistType.EXACT_URL || whitelistRule.getType() == WhitelistType.DOMAIN_NAME) {
            return this.generateFavIconUrl(whitelistRule.getExpression(), defaultIconUrl);
        }
        return defaultIconUrl;
    }

    private String generateFavIconUrl(String expression, String defaultIconUrl) {
        try {
            URI uri = new URI(expression);
            return uri.getScheme() + "://" + uri.getAuthority() + "/favicon.ico";
        }
        catch (URISyntaxException e) {
            return defaultIconUrl;
        }
    }
}

