/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.ui.WhitelistBeanBuilder;
import com.atlassian.plugins.whitelist.ui.WhitelistTypeMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class WhitelistBean {
    private final Integer id;
    private final String expression;
    private final WhitelistType type;
    private final Boolean allowInbound;
    private final String iconUrl;

    @JsonCreator
    public WhitelistBean(@JsonProperty(value="expression") String expression, @JsonProperty(value="type") String type, @JsonProperty(value="allowInbound") Boolean allowInbound) {
        this.id = null;
        this.expression = expression;
        this.type = type != null ? WhitelistTypeMapper.asType(type) : null;
        this.iconUrl = null;
        this.allowInbound = allowInbound;
    }

    public WhitelistBean(WhitelistBeanBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        this.id = builder.id;
        this.expression = builder.expression;
        this.type = builder.type;
        this.iconUrl = builder.iconUrl;
        this.allowInbound = builder.allowInbound;
    }

    public static WhitelistBeanBuilder builder() {
        return new WhitelistBeanBuilder();
    }

    public WhitelistRule asRule() {
        return ImmutableWhitelistRule.builder().id(this.id).expression(this.expression).type(this.type).allowInbound(this.allowInbound.booleanValue()).build();
    }

    public WhitelistRule populateWith(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        String newExpression = (String)MoreObjects.firstNonNull((Object)this.expression, (Object)whitelistRule.getExpression());
        WhitelistType newType = (WhitelistType)MoreObjects.firstNonNull((Object)this.type, (Object)whitelistRule.getType());
        boolean newAllowInbound = (Boolean)MoreObjects.firstNonNull((Object)this.allowInbound, (Object)whitelistRule.isAllowInbound());
        return ImmutableWhitelistRule.builder().id(whitelistRule.getId()).expression(newExpression).type(newType).allowInbound(newAllowInbound).build();
    }

    @Nullable
    public Integer getId() {
        return this.id;
    }

    public String getExpression() {
        return this.expression;
    }

    @JsonIgnore
    public WhitelistType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return WhitelistTypeMapper.asString(this.type);
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Boolean isAllowInbound() {
        return this.allowInbound;
    }

    public boolean isAllowEdit() {
        return this.type != WhitelistType.APPLICATION_LINK;
    }

    public boolean isAllowDelete() {
        return this.type != WhitelistType.APPLICATION_LINK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhitelistBean that = (WhitelistBean)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.expression, (Object)that.expression) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.expression, this.type});
    }

    public String toString() {
        return "WhitelistBean{id=" + this.id + ", expression='" + this.expression + '\'' + ", type=" + this.type + '}';
    }
}

