package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class UserIsSysadminCondition implements Condition
{
    private final UserManager userManager;

    public UserIsSysadminCondition(final UserManager userManager)
    {
        this.userManager = checkNotNull(userManager, "userManager");
    }

    @Override
    public void init(final Map<String, String> params) throws PluginParseException
    {
    }

    @Override
    public boolean shouldDisplay(final Map<String, Object> context)
    {
        final UserKey remoteUserKey = userManager.getRemoteUserKey();
        return remoteUserKey != null && userManager.isSystemAdmin(remoteUserKey);
    }
}
