/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import javax.annotation.Nullable;

public class WhitelistRuleComparator
implements Comparator<WhitelistRule> {
    private final ApplicationLinkService applicationLinkService;

    public WhitelistRuleComparator(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    public int compare(WhitelistRule o1, WhitelistRule o2) {
        if (o1.getType() == WhitelistType.APPLICATION_LINK && o2.getType() == WhitelistType.APPLICATION_LINK) {
            return this.compareApplicationLinks(o1, o2);
        }
        return ComparisonChain.start().compare((Comparable)o1.getType(), (Comparable)o2.getType()).compare((Object)o1.getExpression(), (Object)o2.getExpression(), String.CASE_INSENSITIVE_ORDER).result();
    }

    private int compareApplicationLinks(WhitelistRule o1, WhitelistRule o2) {
        ApplicationLink applicationLink1 = this.getApplicationName(o1);
        ApplicationLink applicationLink2 = this.getApplicationName(o2);
        if (applicationLink1 == null || applicationLink2 == null) {
            return o1.getExpression().compareToIgnoreCase(o2.getExpression());
        }
        return ComparisonChain.start().compare((Comparable)TypeId.getTypeId((ApplicationType)applicationLink1.getType()), (Comparable)TypeId.getTypeId((ApplicationType)applicationLink2.getType())).compare((Comparable)((Object)applicationLink1.getName()), (Comparable)((Object)applicationLink2.getName())).result();
    }

    @Nullable
    private ApplicationLink getApplicationName(WhitelistRule whitelistRule) {
        try {
            ApplicationId applicationId = new ApplicationId(whitelistRule.getExpression());
            return this.applicationLinkService.getApplicationLink(applicationId);
        }
        catch (TypeNotInstalledException e) {
            return null;
        }
    }
}

