package com.atlassian.plugins.whitelist.events;

import com.atlassian.plugins.whitelist.WhitelistRule;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public abstract class WhitelistRuleEvent
{
    @Nonnull
    protected final WhitelistRule whitelistRule;

    public WhitelistRuleEvent(@Nonnull final WhitelistRule whitelistRule)
    {
        this.whitelistRule = checkNotNull(whitelistRule, "whitelistRule");
    }

    /**
     * @return the whitelist rule that is subject of this event
     */
    @Nonnull
    public WhitelistRule getWhitelistRule()
    {
        return whitelistRule;
    }
}
