package com.atlassian.plugins.whitelist.applinks;

import com.atlassian.annotations.PublicApi;

/**
 * Handles the settings for how restrictively application links are treated by
 * the whitelist by default.
 *
 * @since 5.0
 */
@PublicApi
public interface ApplicationLinkRestrictions
{
    /**
     * Sets how restrictively application links are treated by default.
     * @param applicationLinkRestrictiveness Value defining how restrictively application links are treated.
     */
    void setRestrictiveness(ApplicationLinkRestrictiveness applicationLinkRestrictiveness);

    /**
     * Gets the restrictiveness of application links.
     * @return Value defining how restrictively application links are treated by default.
     */
    ApplicationLinkRestrictiveness getRestrictiveness();
}
