package com.atlassian.plugins.whitelist.applinks;

/**
 * Defines how restrictively Application Links are treated in the whitelist
 *
 * @since 5.0
 */
public enum ApplicationLinkRestrictiveness {
    ALLOW_AUTHENTICATED,
    ALLOW_ANONYMOUS,
    DENY;

    public boolean createApplinkRules() {
        return this != DENY;
    }

    public boolean allowAnonymous() {
        return this == ALLOW_ANONYMOUS;
    }
}
