package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Objects;

import javax.annotation.concurrent.Immutable;
import java.io.Serializable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
@Immutable
@PublicApi
public final class ImmutableWhitelistRule implements WhitelistRule, Serializable
{
    private final Integer id;
    private final String expression;
    private final WhitelistType type;
    private final boolean allowInbound;
    private final boolean authenticationRequired;

    public ImmutableWhitelistRule(final ImmutableWhitelistRuleBuilder builder)
    {
        checkNotNull(builder, "builder");
        this.id = builder.getId();
        this.expression = checkNotNull(builder.getExpression(), "expression");
        this.type = checkNotNull(builder.getType(), "type");
        this.allowInbound = builder.isAllowInbound();
        this.authenticationRequired = builder.isAuthenticationRequired();
    }

    public ImmutableWhitelistRule(final WhitelistRule copy)
    {
        checkNotNull(copy, "copy");
        this.id = copy.getId();
        this.expression = checkNotNull(copy.getExpression(), "expression");
        this.type = checkNotNull(copy.getType(), "type");
        this.allowInbound = copy.isAllowInbound();
        this.authenticationRequired = copy.isAuthenticationRequired();
    }


    public static ImmutableWhitelistRuleBuilder builder()
    {
        return new ImmutableWhitelistRuleBuilder();
    }

    @Override
    public Integer getId()
    {
        return id;
    }

    @Override
    public String getExpression()
    {
        return expression;
    }

    @Override
    public WhitelistType getType()
    {
        return type;
    }

    @Override
    public boolean isAllowInbound()
    {
        return allowInbound;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return authenticationRequired;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final ImmutableWhitelistRule that = (ImmutableWhitelistRule) o;
        return Objects.equal(id, that.id) &&
                Objects.equal(expression, that.expression) &&
                Objects.equal(type, that.type) &&
                Objects.equal(allowInbound, that.allowInbound) &&
                Objects.equal(authenticationRequired, that.authenticationRequired);
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(id, expression, type, allowInbound, authenticationRequired);
    }

    @Override
    public String toString()
    {
        return "ImmutableWhitelistRule{id="+ id
                + ", expression='" + expression + '\''
                + ", type=" + type
                + ", allowInbound=" + allowInbound
                + ", authenticationRequired=" + authenticationRequired
                + '}';
    }
}
