package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.sal.api.user.UserKey;

/**
 * A simple interface for the purpose of allowing OutboundWhitelist to check the
 * access status of a UserKey.
 *
 * @since 5.0
 */
@PublicSpi
public interface AccessManager {
    /**
     * @return <code>true</code> if user is authenticated and has appropriate
     * basic use access to the product (e.g. licensed, active user).
     */
    boolean canUserAccessProduct(UserKey userKey);
}
