/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRuleBuilder;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistRuleNotFoundException;
import com.atlassian.plugins.whitelist.WhitelistRulePredicates;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.events.ClearWhitelistCacheEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleAddedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleChangedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleRemovedEvent;
import com.atlassian.plugins.whitelist.permission.PermissionChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WhitelistServiceImpl
implements WhitelistService,
InitializingBean,
DisposableBean {
    private final WhitelistOnOffSwitch whitelistOnOffSwitch;
    private final WhitelistManager whitelistManager;
    private final PermissionChecker permissionChecker;
    private final EventPublisher eventPublisher;
    private final Cache<Object, Collection<WhitelistRule>> cache = CacheBuilder.newBuilder().build(CacheLoader.from((Supplier)new Supplier<Collection<WhitelistRule>>(){

        public Collection<WhitelistRule> get() {
            return ImmutableList.copyOf((Iterable)Iterables.transform(WhitelistServiceImpl.this.whitelistManager.getAll(), ImmutableWhitelistRuleBuilder.COPY));
        }
    }));

    public WhitelistServiceImpl(WhitelistOnOffSwitch whitelistOnOffSwitch, WhitelistManager whitelistManager, PermissionChecker permissionChecker, EventPublisher eventPublisher) {
        this.whitelistOnOffSwitch = whitelistOnOffSwitch;
        this.whitelistManager = whitelistManager;
        this.permissionChecker = permissionChecker;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.whitelistOnOffSwitch.isEnabled();
    }

    @Override
    public void enableWhitelist() {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.whitelistOnOffSwitch.enable();
    }

    @Override
    public void disableWhitelist() {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.whitelistOnOffSwitch.disable();
    }

    @Override
    public WhitelistRule add(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        WhitelistServiceImpl.checkTypeNotApplicationLink(whitelistRule);
        return this.whitelistManager.add(whitelistRule);
    }

    @Override
    public WhitelistRule update(WhitelistRule whitelistRule) {
        Preconditions.checkNotNull((Object)whitelistRule, (Object)"whitelistRule");
        Integer whitelistRuleId = whitelistRule.getId();
        Preconditions.checkArgument((whitelistRuleId != null ? 1 : 0) != 0, (Object)("Cannot update whitelist rule, the given instance has no database id: " + whitelistRule));
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        this.enforceApplicationLinkUpdateRules(whitelistRule);
        return this.whitelistManager.update(whitelistRule);
    }

    @Override
    public void remove(int id) {
        this.permissionChecker.checkCurrentUserCanManageWhitelist();
        WhitelistRule whitelistRule = this.get(id);
        if (whitelistRule != null) {
            WhitelistServiceImpl.checkTypeNotApplicationLink(whitelistRule);
            this.whitelistManager.remove(whitelistRule);
        }
    }

    @Override
    public Collection<WhitelistRule> getAll() {
        return (Collection)this.cache.getUnchecked((Object)this);
    }

    @Override
    @Nullable
    public WhitelistRule get(int id) {
        return (WhitelistRule)Iterables.find((Iterable)((Iterable)this.cache.getUnchecked((Object)this)), WhitelistRulePredicates.withId(id), null);
    }

    @EventListener
    public void onWhitelistRuleAddedEvent(WhitelistRuleAddedEvent event) {
        this.cache.invalidateAll();
    }

    @EventListener
    public void onWhitelistRuleChanged(WhitelistRuleChangedEvent event) {
        this.cache.invalidateAll();
    }

    @EventListener
    public void onWhitelistRuleRemoved(WhitelistRuleRemovedEvent event) {
        this.cache.invalidateAll();
    }

    @EventListener
    public void onClearWhitelistCacheEvent(ClearWhitelistCacheEvent event) {
        this.cache.invalidateAll();
    }

    private static void checkTypeNotApplicationLink(WhitelistRule whitelistRule) {
        if (whitelistRule.getType() == WhitelistType.APPLICATION_LINK) {
            throw new IllegalArgumentException("Adding new application link whitelist rules is not supported, they are managed internally.");
        }
    }

    private void enforceApplicationLinkUpdateRules(WhitelistRule whitelistRule) {
        Integer whitelistRuleId = whitelistRule.getId();
        Preconditions.checkNotNull((Object)whitelistRuleId, (Object)"whitelistRuleId");
        WhitelistRule existingWhitelistRule = this.get(whitelistRuleId);
        if (existingWhitelistRule == null) {
            throw new WhitelistRuleNotFoundException("Whitelist rule with id '" + whitelistRuleId + "' not found.");
        }
        if (existingWhitelistRule.getType() == WhitelistType.APPLICATION_LINK) {
            Preconditions.checkArgument((whitelistRule.getType() == WhitelistType.APPLICATION_LINK && whitelistRule.getExpression().equals(existingWhitelistRule.getExpression()) ? 1 : 0) != 0, (Object)"Cannot change the type or expression of this application link whitelist rule.");
        } else {
            Preconditions.checkArgument((whitelistRule.getType() != WhitelistType.APPLICATION_LINK ? 1 : 0) != 0, (Object)"Cannot change the type to application link.");
        }
    }
}

