package com.atlassian.plugins.whitelist.permission;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Uses the JIRA implementation to allow code in JIRA to bypass the permission check when running in a system context.
 * @since 1.0
 */
public class JiraPermissionChecker extends AbstractPermissionChecker implements PermissionChecker
{
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;

    public JiraPermissionChecker(final JiraAuthenticationContext jiraAuthenticationContext, final PermissionManager permissionManager)
    {
        this.jiraAuthenticationContext = checkNotNull(jiraAuthenticationContext, "jiraAuthenticationContext");
        this.permissionManager = checkNotNull(permissionManager, "permissionManager");
    }

    @Override
    public boolean canCurrentUserManageWhitelist()
    {
        return permissionManager.hasPermission(Permissions.SYSTEM_ADMIN, jiraAuthenticationContext.getUser());
    }
}
