package com.atlassian.plugins.whitelist.permission;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Uses pure SAL functionality.
 * @since 1.0
 */
public class DefaultPermissionChecker extends AbstractPermissionChecker
{
    private final UserManager userManager;

    public DefaultPermissionChecker(final UserManager userManager)
    {
        this.userManager = checkNotNull(userManager, "userManager");
    }

    @Override
    public boolean canCurrentUserManageWhitelist()
    {
        final UserKey remoteUserKey = userManager.getRemoteUserKey();
        return userManager.isSystemAdmin(remoteUserKey);
    }
}
