package com.atlassian.plugins.whitelist.permission;

import com.atlassian.plugins.whitelist.NotAuthorizedException;

/**
 * @since 1.0
 */
public abstract class AbstractPermissionChecker implements PermissionChecker
{
    @Override
    public void checkCurrentUserCanManageWhitelist()
    {
        if (!canCurrentUserManageWhitelist())
        {
            throw new NotAuthorizedException("The current user is not allowed to change the whitelist.");
        }
    }
}
