package com.atlassian.plugins.whitelist.migration.confluence.gadgets;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.migration.AbstractWhitelistPluginUpgradeTask;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/**
 * @since 1.0
 */
public class ConfluenceGadgetsWhitelistMigration extends AbstractWhitelistPluginUpgradeTask
{
    private static final String BANDANA_KEY = "userconfigured.gadget.whitelist";
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceGadgetsWhitelistMigration.class);

    private final BandanaManager bandanaManager;
    private final WhitelistManager whitelistManager;
    private final TransactionTemplate transactionTemplate;

    public ConfluenceGadgetsWhitelistMigration(final BandanaManager bandanaManager, final WhitelistManager whitelistManager, final TransactionTemplate transactionTemplate)
    {
        this.bandanaManager = bandanaManager;
        this.whitelistManager = whitelistManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public int getBuildNumber()
    {
        return 3;
    }

    @Override
    public String getShortDescription()
    {
        return "Migrate existing Confluence Gadget whitelist data.";
    }

    @Override
    public Collection<Message> doUpgrade() throws Exception
    {
        return transactionTemplate.execute(new TransactionCallback<Collection<Message>>()
        {
            @Override
            public Collection<Message> doInTransaction()
            {
                final HashSet<String> existingData = readExistingData();
                final Collection<WhitelistRule> whitelistRules = Collections2.transform(existingData, toWhitelistRuleData());
                logger.debug("Migrating {} whitelist rules ...", whitelistRules.size());
                whitelistManager.addAll(whitelistRules);
                return Collections.emptyList();
            }

            @SuppressWarnings("unchecked")
            private HashSet<String> readExistingData()
            {
                final Object data = bandanaManager.getValue(new ConfluenceBandanaContext(), BANDANA_KEY);
                if (data instanceof HashSet)
                {
                    return (HashSet<String>) data;
                }
                else
                {
                    return new HashSet<String>();
                }
            }

            private Function<String, WhitelistRule> toWhitelistRuleData()
            {
                return new Function<String, WhitelistRule>()
                {
                    @Override
                    public WhitelistRule apply(@Nullable final String input)
                    {
                        return input != null ? ImmutableWhitelistRule.builder().expression(input).type(WhitelistType.EXACT_URL).build() : null;
                    }
                };
            }
        });
    }
}
