package com.atlassian.plugins.whitelist.migration;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.applinks.ApplicationLinkWhitelistRule;
import com.atlassian.plugins.whitelist.applinks.CachingApplicationLinkService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;

import java.util.Collection;
import java.util.Collections;

/**
 * @since 1.0
 */
public class ApplicationLinksMigration extends AbstractWhitelistPluginUpgradeTask
{
    private final CachingApplicationLinkService applicationLinkService;
    private final WhitelistManager whitelistManager;
    private final TransactionTemplate transactionTemplate;

    public ApplicationLinksMigration(final CachingApplicationLinkService applicationLinkService, final WhitelistManager whitelistManager, final TransactionTemplate transactionTemplate)
    {
        this.applicationLinkService = applicationLinkService;
        this.whitelistManager = whitelistManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public int getBuildNumber()
    {
        return 1;
    }

    @Override
    public String getShortDescription()
    {
        return "Migrate existing application links to the whitelist.";
    }

    @Override
    public Collection<Message> doUpgrade() throws Exception
    {
        return transactionTemplate.execute(new TransactionCallback<Collection<Message>>()
        {
            @Override
            public Collection<Message> doInTransaction()
            {
                final Iterable<ApplicationLink> applicationLinks = applicationLinkService.getApplicationLinks();
                whitelistManager.addAll(Iterables.transform(applicationLinks, new Function<ApplicationLink, WhitelistRule>()
                {
                    @Override
                    public WhitelistRule apply(final ApplicationLink applicationLink)
                    {
                        return new ApplicationLinkWhitelistRule(applicationLink);
                    }
                }));
                return Collections.emptyList();
            }
        });
    }
}
