package com.atlassian.plugins.whitelist.matcher;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;

import java.net.URI;
import java.net.URISyntaxException;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Matches any uri served from the application itself.
 * @since 1.0
 */
public class SelfUrlMatcher implements Predicate<URI>
{
    private final ApplicationProperties applicationProperties;

    public SelfUrlMatcher(final ApplicationProperties applicationProperties)
    {
        this.applicationProperties = checkNotNull(applicationProperties, "applicationProperties");
    }

    @Override
    public boolean apply(final URI uri)
    {
        try
        {
            final URI normalizedUri = MatcherUtils.normalizeUri(uri);
            final String baseUrl = Strings.nullToEmpty(applicationProperties.getBaseUrl(UrlMode.CANONICAL));
            return normalizedUri.toString().startsWith(baseUrl);
        }
        catch (URISyntaxException e)
        {
            return false;
        }
    }
}
