package com.atlassian.plugins.whitelist.matcher;

import com.google.common.base.Predicate;

import java.net.URI;
import java.net.URISyntaxException;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class ExactUrlMatcher implements Predicate<URI>
{
    private final URI expression;

    public ExactUrlMatcher(final String expression)
    {
        this.expression = MatcherUtils.normalizeUriUnchecked(URI.create(checkNotNull(expression, "expression")));
    }

    @Override
    public boolean apply(final URI uri)
    {
        try
        {
            final URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return expression.equals(normalizedUri);
        }
        catch (URISyntaxException e)
        {
            return false;
        }
    }
}
