package com.atlassian.plugins.whitelist.matcher;

import com.google.common.base.Predicate;

import java.net.URI;
import java.net.URISyntaxException;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class DomainNameMatcher implements Predicate<URI>
{
    private final String expression;

    public DomainNameMatcher(final String expression)
    {
        this.expression = checkNotNull(expression, "expression");
    }

    @Override
    public boolean apply(final URI uri)
    {
        try
        {
            final URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return expression.equalsIgnoreCase(normalizedUri.getScheme() + "://" + normalizedUri.getAuthority());
        }
        catch (URISyntaxException e)
        {
            return false;
        }
    }
}
