/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.diagnostics;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.event.remote.diagnostics.RemoteEventConsumerStatus;
import com.atlassian.event.remote.impl.RemoteEventCapabilityRegistrar;
import com.atlassian.event.remote.internal.http.HttpRequestService;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.event.remote.internal.http.ResponseBodyHandler;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.failurecache.Cache;
import com.atlassian.failurecache.CacheFactory;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.failurecache.failures.ExponentialBackOffFailureCache;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={RemoteEventConsumerStatus.class})
public class DefaultRemoteEventConsumerStatus
implements RemoteEventConsumerStatus {
    public static final Duration PUBLISHED_EVENTS_CACHE_TIMEOUT = Duration.standardSeconds((long)Long.getLong("remote.event.consumer-status.maxage.seconds", 60L));
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteEventConsumerStatus.class);
    private static final double DEFAULT_BACK_OFF_RATE = Integer.getInteger("navlink.failurecache.backoff", 2).intValue();
    private static final long DEFAULT_INITIAL_EXPIRY_MS = Long.getLong("navlink.failurecache.initialexpiryMs", TimeUnit.SECONDS.toMillis(1L));
    private static final int DEFAULT_MAX_ENTRIES = Integer.getInteger("navlink.failurecache.maxEntries", 1000);
    private static final long DEFAULT_MAX_EXPIRY_MS = Long.getLong("navlink.failurecache.maxExpiryMs", TimeUnit.MINUTES.toMillis(1L));
    private static final String REMOTE_EVENT_PRODUCER_CAPABILITY = "atlassian-remote-event-producer";
    private final Cache<PublishedEvent> cache;
    private final RemoteEventCapabilityRegistrar capabilityRegistrar;
    private final JsonUtil jsonUtil;
    private final HttpRequestService httpRequestService;
    private final HttpUtil httpUtil;

    @Autowired
    public DefaultRemoteEventConsumerStatus(RemoteEventCapabilityRegistrar capabilityRegistrar, @ComponentImport CacheFactory cacheFactory, @ComponentImport JsonUtil jsonUtil, @ComponentImport HttpRequestService httpRequestService, @ComponentImport HttpUtil httpUtil) {
        ExponentialBackOffFailureCache failureCache = new ExponentialBackOffFailureCache.Builder().backOffRate(DEFAULT_BACK_OFF_RATE).initialExpiry(DEFAULT_INITIAL_EXPIRY_MS, TimeUnit.MILLISECONDS).maxEntries(DEFAULT_MAX_ENTRIES).maxExpiry(DEFAULT_MAX_EXPIRY_MS, TimeUnit.MILLISECONDS).build();
        this.capabilityRegistrar = capabilityRegistrar;
        this.jsonUtil = jsonUtil;
        this.httpRequestService = httpRequestService;
        this.httpUtil = httpUtil;
        this.cache = cacheFactory.createExpirationDateBasedCache((CacheLoader)new PublishedEventCacheLoader(), failureCache);
    }

    public Map<ApplicationId, Iterable<String>> getRemotelyPublishedEvents() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        try {
            this.cache.refresh().get(PUBLISHED_EVENTS_CACHE_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            log.info("Problem getting remotely published events", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        for (PublishedEvent e : this.cache.getValues()) {
            builder.put((Object)e.applicationId, (Object)e.events);
        }
        return builder.build();
    }

    public Iterable<String> getSubscribedEvents() {
        return this.capabilityRegistrar.getCapabilities();
    }

    public void reset() {
        this.cache.clear();
    }

    private class PublishedEventBodyHandler
    implements ResponseBodyHandler<ExpiringValue<PublishedEvent>> {
        private final ApplicationId applicationId;

        private PublishedEventBodyHandler(ApplicationId applicationId) {
            this.applicationId = applicationId;
        }

        public ExpiringValue<PublishedEvent> handle(String body, long staleAfterInMillis, long expiredAfterMillis) throws IOException {
            Object capabilities = ImmutableList.of();
            if (body != null && !body.isEmpty()) {
                capabilities = (Iterable)DefaultRemoteEventConsumerStatus.this.jsonUtil.read(body, Iterable.class);
            }
            return new ExpiringValue((Object)new PublishedEvent(this.applicationId, (Iterable)capabilities), staleAfterInMillis, expiredAfterMillis);
        }
    }

    private class PublishedEventCacheLoader
    implements CacheLoader<String, PublishedEvent> {
        private PublishedEventCacheLoader() {
        }

        public ImmutableSet<String> getKeys() {
            return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)DefaultRemoteEventConsumerStatus.this.httpUtil.getLinkedAppsSupportingStatus(DefaultRemoteEventConsumerStatus.REMOTE_EVENT_PRODUCER_CAPABILITY), (Function)new Function<LinkedAppWithCapabilities, String>(){

                public String apply(@Nullable LinkedAppWithCapabilities app) {
                    return app == null ? null : app.getApplicationLinkId();
                }
            }));
        }

        public ListenableFuture<ExpiringValue<PublishedEvent>> loadValue(String key) {
            LinkedAppWithCapabilities app = DefaultRemoteEventConsumerStatus.this.httpUtil.getAppWithCapabilities(key, DefaultRemoteEventConsumerStatus.REMOTE_EVENT_PRODUCER_CAPABILITY);
            try {
                if (app != null) {
                    String capabilityUrl = DefaultRemoteEventConsumerStatus.this.httpUtil.getCapabilityUrl(app, DefaultRemoteEventConsumerStatus.REMOTE_EVENT_PRODUCER_CAPABILITY);
                    log.debug("Querying " + key + " at " + capabilityUrl);
                    return Futures.immediateFuture((Object)DefaultRemoteEventConsumerStatus.this.httpRequestService.get(capabilityUrl, (ResponseBodyHandler)new PublishedEventBodyHandler(new ApplicationId(app.getApplicationLinkId()))));
                }
                return Futures.immediateFuture((Object)new ExpiringValue(null, 0L, 0L));
            }
            catch (Exception e) {
                log.debug("Unexpected exception querying " + key + " at " + app.getCapabilityUrl(DefaultRemoteEventConsumerStatus.REMOTE_EVENT_PRODUCER_CAPABILITY), (Throwable)e);
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
    }

    private class PublishedEvent {
        private final ApplicationId applicationId;
        private final Iterable<String> events;

        private PublishedEvent(ApplicationId applicationId, Iterable<String> events) {
            this.applicationId = applicationId;
            this.events = events;
        }
    }
}

