/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.remote.RemoteEvent;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ListenerEventClassExtractor {
    private static final Class ANNOTATION_CLASS = EventListener.class;

    public Set<Class> getRemoteEventClasses(Object listener) {
        ImmutableSet.Builder capabilities = ImmutableSet.builder();
        for (Method method : listener.getClass().getMethods()) {
            if (!this.isValidMethod(method)) continue;
            capabilities.add(method.getParameterTypes()[0]);
        }
        return capabilities.build();
    }

    private boolean isValidMethod(Method method) {
        return this.isAnnotated(method) && this.hasValidParameter(method);
    }

    private boolean isAnnotated(Method method) {
        return method.getAnnotation(ANNOTATION_CLASS) != null;
    }

    private boolean hasValidParameter(Method method) {
        return method.getParameterTypes().length == 1 && RemoteEvent.class.isAssignableFrom(method.getParameterTypes()[0]) && RemoteEvent.getCapability(method.getParameterTypes()[0]) != null;
    }
}

