/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.http;

import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.springframework.stereotype.Component;

@Component
public class HttpClientFactory {
    public static final int SOCKET_TIMEOUT = Integer.getInteger("remote.event.httpclient.sotimeout.millis", 3000);
    public static final int CONNECTION_TIMEOUT = Integer.getInteger("remote.event.httpclient.conntimeout.millis", 1500);
    public static final int CONNECTION_POOL_TIMEOUT = Integer.getInteger("remote.event.httpclient.pool.timeout.millis", 3600000);

    public HttpClient createHttpClient() {
        return HttpClientBuilder.create().setConnectionTimeToLive((long)CONNECTION_POOL_TIMEOUT, TimeUnit.MILLISECONDS).setDefaultRequestConfig(this.createRequestConfig()).setRoutePlanner(this.createRoutePlaner()).useSystemProperties().build();
    }

    private RequestConfig createRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(SOCKET_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).setCookieSpec("ignoreCookies").build();
    }

    private HttpRoutePlanner createRoutePlaner() {
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }
}

