/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatus;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatusCallback;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
public class RemoteEventCommonResource {
    public static final String URL_HASH = "urlHash";
    public static final String RESET = "reset";
    private static final Logger log = LoggerFactory.getLogger(RemoteEventCommonResource.class);
    private final ApplicationLinkService applicationLinks;
    private final JsonUtil jsonUtil;
    private final RemoteStatusCallback connectionStatus;
    private final RequestAuthorizor requestAuthorizor;

    public RemoteEventCommonResource(ApplicationLinkService applicationLinks, JsonUtil jsonUtil, RemoteStatusCallback connectionStatus, RequestAuthorizor requestAuthorizor) {
        this.applicationLinks = applicationLinks;
        this.connectionStatus = connectionStatus;
        this.jsonUtil = jsonUtil;
        this.requestAuthorizor = requestAuthorizor;
    }

    @GET
    @AnonymousAllowed
    @Path(value="status")
    public Response status() {
        if (this.requestAuthorizor.isAuthorized()) {
            return Response.ok((Object)"OK").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="status/{applicationId}")
    public Response statusCallback(@PathParam(value="applicationId") String applicationId, @QueryParam(value="urlHash") String urlHash) {
        if (this.requestAuthorizor.isAuthorized()) {
            try {
                ApplicationLink applicationLink = this.getApplicationLink(applicationId, urlHash);
                RemoteStatus remoteStatus = RemoteStatus.EMPTY_STATUS;
                if (applicationLink != null) {
                    remoteStatus = this.connectionStatus.get(applicationLink);
                } else {
                    log.info("Missing expected AppLink with remote host ID " + applicationId + " and URL hash " + urlHash);
                }
                return Response.ok((Object)this.jsonUtil.write(remoteStatus), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            catch (Exception e) {
                log.info("Exception while accessing AppLink with remote host ID " + applicationId + " and URL hash " + urlHash, (Throwable)e);
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private ApplicationLink getApplicationLink(String applicationId, String urlHash) throws TypeNotInstalledException {
        ApplicationLink applicationLink = this.applicationLinks.getApplicationLink(new ApplicationId(applicationId));
        return applicationLink == null && urlHash != null ? this.applicationLinks.getApplicationLink(new ApplicationId(urlHash)) : applicationLink;
    }
}

