/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.lang.reflect.Method;

public class CaseInsensitiveEnumDeserializer
extends StdScalarDeserializer<Enum<?>> {
    protected CaseInsensitiveEnumDeserializer(Class<Enum<?>> clazz) {
        super(clazz);
    }

    public Enum<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String text = jsonParser.getText().toUpperCase();
        try {
            Method valueOfMethod = this.handledType().getDeclaredMethod("valueOf", String.class);
            return (Enum)valueOfMethod.invoke(null, text);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize enum " + this.handledType().getName() + " from " + text, e);
        }
    }
}

