/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.diagnostics;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.event.remote.impl.diagnostics.RemoteConnectionTester;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatus;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteStatusCallback {
    private final RemoteConnectionTester remoteConnectionTester;
    private final RequestAuthorizor requestAuthorizor;

    @Autowired
    public RemoteStatusCallback(RemoteConnectionTester remoteConnectionTester, RequestAuthorizor requestAuthorizor) {
        this.remoteConnectionTester = remoteConnectionTester;
        this.requestAuthorizor = requestAuthorizor;
    }

    public RemoteStatus get(ApplicationLink applicationLink) {
        RemoteStatus.Builder builder = new RemoteStatus.Builder();
        builder.setConnectionStatus(this.remoteConnectionTester.canRemoteAcceptEvents(applicationLink));
        builder.addConfiguredAuthenticationProviders(this.requestAuthorizor.getAuthenticationProviderStatuses(applicationLink));
        return builder.build();
    }
}

