/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.json;

import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.internal.json.SerializationRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SerializationRegistrar.class})
public class RemoteEventDeserializer
extends StdDeserializer<RemoteEvent>
implements SerializationRegistrar {
    public static final JavaType TYPE = SimpleType.construct(RemoteEvent.class);
    private final ConcurrentMap<String, Class> capabilityClassMap = new ConcurrentHashMap<String, Class>();

    public RemoteEventDeserializer() {
        super(TYPE);
    }

    public RemoteEvent deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec objectMapper = jsonParser.getCodec();
        ObjectNode root = (ObjectNode)objectMapper.readTree(jsonParser);
        Class eventClass = this.getEventClass((JsonNode)root);
        if (eventClass != null) {
            return (RemoteEvent)objectMapper.readValue(root.traverse(objectMapper), eventClass);
        }
        return null;
    }

    @Override
    public RemoteEventDeserializer register(Class remoteEventClass) {
        String capability = RemoteEvent.getCapability((Class)remoteEventClass);
        if (capability != null) {
            this.capabilityClassMap.put(capability, remoteEventClass);
        }
        return this;
    }

    @Override
    public RemoteEventDeserializer register(Collection<Class> remoteEventClasses) {
        for (Class remoteEventClass : remoteEventClasses) {
            this.register(remoteEventClass);
        }
        return this;
    }

    @Override
    public void unregister(Class remoteEventClass) {
        String capability = RemoteEvent.getCapability((Class)remoteEventClass);
        if (capability != null) {
            this.capabilityClassMap.remove(capability);
        }
    }

    @Override
    public void unregister(Collection<Class> remoteEventClasses) {
        for (Class remoteEventClass : remoteEventClasses) {
            this.unregister(remoteEventClass);
        }
    }

    private Class getEventClass(JsonNode root) throws IOException {
        JsonNode capabilities = root.findValue("capabilities");
        if (capabilities != null) {
            for (JsonNode n : capabilities) {
                Class c = (Class)this.capabilityClassMap.get(n.asText());
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }
}

