/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.diagnostics;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.event.remote.diagnostics.RemoteEventConnectionStatus;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatus;
import com.atlassian.event.remote.impl.http.HttpClientFactory;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteConnectionTester {
    private static final Logger log = LoggerFactory.getLogger(RemoteConnectionTester.class);
    private static final int OK = 200;
    private static final int NO_AUTH = 401;
    private static final int NO_CONTENT = 204;
    private static final int NOT_FOUND = 404;
    public static final String REMOTE_EVENT_STATUS_CAPABILITY = "atlassian-remote-event-status";
    private final InternalHostApplication host;
    private final HttpUtil httpUtil;
    private final JsonUtil jsonUtil;
    private final RequestAuthorizor requestAuthorizor;

    @Autowired
    public RemoteConnectionTester(@ComponentImport InternalHostApplication host, HttpUtil httpUtil, JsonUtil jsonUtil, RequestAuthorizor requestAuthorizor) {
        this.host = host;
        this.httpUtil = httpUtil;
        this.jsonUtil = jsonUtil;
        this.requestAuthorizor = requestAuthorizor;
    }

    public RemoteEventConnectionStatus.ConnectionStatus canRemoteAcceptEvents(ApplicationLink applicationLink) {
        LinkedAppWithCapabilities app = this.httpUtil.getAppWithCapabilities(applicationLink.getId().get(), REMOTE_EVENT_STATUS_CAPABILITY);
        return app == null ? RemoteEventConnectionStatus.ConnectionStatus.NOT_AVAILABLE : this.canRemoteAcceptEvents(applicationLink, app);
    }

    public RemoteEventConnectionStatus.ConnectionStatus canRemoteAcceptEvents(ApplicationLink applicationLink, LinkedAppWithCapabilities app) {
        try {
            return this.sendAuthorizedRequest(applicationLink, this.getStatusUrl(applicationLink, app), Request.MethodType.GET, new ReturningResponseHandler<Response, RemoteEventConnectionStatus.ConnectionStatus>(){

                public RemoteEventConnectionStatus.ConnectionStatus handle(Response response) throws ResponseException {
                    if (response.getStatusCode() == 200 || response.getStatusCode() == 204) {
                        return RemoteEventConnectionStatus.ConnectionStatus.WORKING;
                    }
                    if (response.getStatusCode() == 401) {
                        return RemoteEventConnectionStatus.ConnectionStatus.NOT_AUTHENTICATED;
                    }
                    if (response.getStatusCode() == 404) {
                        return RemoteEventConnectionStatus.ConnectionStatus.NOT_AVAILABLE;
                    }
                    log.debug("Got unexpected response status code when requesting status of remote host: {} - {}", (Object)response.getStatusCode(), (Object)response.getStatusText());
                    return RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN;
                }
            });
        }
        catch (Exception e) {
            log.info("Exception requesting status for remote host " + applicationLink, (Throwable)e);
            return RemoteEventConnectionStatus.ConnectionStatus.NOT_REACHABLE;
        }
    }

    public Option<RemoteStatus> getRemoteStatus(final ApplicationLink applicationLink, LinkedAppWithCapabilities app) {
        try {
            return this.sendAuthorizedRequest(applicationLink, this.getStatusCallbackUrl(applicationLink, app), Request.MethodType.GET, new ReturningResponseHandler<Response, Option<RemoteStatus>>(){

                public Option<RemoteStatus> handle(Response response) throws ResponseException {
                    if (response.isSuccessful()) {
                        try {
                            return Option.option((Object)RemoteConnectionTester.this.jsonUtil.read(response.getResponseBodyAsStream(), RemoteStatus.class));
                        }
                        catch (IOException e) {
                            log.info("Exception requesting status for remote host " + applicationLink, (Throwable)e);
                        }
                    }
                    return Option.none();
                }
            });
        }
        catch (Exception e) {
            log.info("Exception requesting status for remote host " + applicationLink, (Throwable)e);
            return Option.none();
        }
    }

    private String getStatusCallbackUrl(ApplicationLink applicationLink, LinkedAppWithCapabilities app) throws URISyntaxException {
        String statusUrl = this.getStatusUrl(applicationLink, app);
        return statusUrl + (statusUrl.endsWith("/") ? "" : "/") + this.host.getId().get() + "?" + "urlHash" + "=" + ApplicationIdUtil.generate((URI)this.host.getBaseUrl()).get();
    }

    private String getStatusUrl(ApplicationLink applicationLink, LinkedAppWithCapabilities app) throws URISyntaxException {
        return this.httpUtil.getUrl(applicationLink.getRpcUrl().toASCIIString(), app.getCapabilityUrl(REMOTE_EVENT_STATUS_CAPABILITY)).toASCIIString();
    }

    private <T> T sendAuthorizedRequest(ApplicationLink applicationLink, String url, Request.MethodType method, ReturningResponseHandler<Response, T> handler) throws ResponseException, CredentialsRequiredException {
        ApplicationLinkRequest request = this.requestAuthorizor.getAuthorizedRequestFactory(applicationLink).createRequest(method, url);
        request.setConnectionTimeout((int)HttpClientFactory.CONNECTION_TIMEOUT.getMillis());
        return (T)request.executeAndReturn(handler);
    }
}

