/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.remote.annotation.Capability;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

@AsynchronousPreferred
@Capability(value="atlassian-remote-event")
public class RemoteEvent {
    private String sourceId = null;
    private URI sourceUrl = null;

    protected RemoteEvent() {
    }

    public boolean fromRemote() {
        return this.sourceId != null;
    }

    @Nullable
    public String getSourceId() {
        return this.sourceId;
    }

    @Nullable
    public URI getSourceUrl() {
        return this.sourceUrl;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public static List<String> getCapabilities(Object event) {
        return RemoteEvent.getCapabilities(event.getClass());
    }

    public static List<String> getCapabilities(Class<?> eventClass) {
        ImmutableList.Builder builder = ImmutableList.builder();
        while (eventClass != null) {
            String capability = RemoteEvent.getCapability(eventClass);
            if (capability != null) {
                builder.add((Object)capability);
            }
            eventClass = eventClass.getSuperclass();
        }
        return builder.build();
    }

    public static String getCapability(Class<?> eventClass) {
        Capability capability = eventClass.getAnnotation(Capability.class);
        return capability == null ? null : capability.value();
    }
}

